/*
 * Decompiled with CFR 0.152.
 */
package fr.siroz.cariboustonks.feature.hunting;

import fr.siroz.cariboustonks.CaribouStonks;
import fr.siroz.cariboustonks.config.ConfigManager;
import fr.siroz.cariboustonks.core.data.algo.BazaarItemAnalytics;
import fr.siroz.cariboustonks.core.data.hypixel.HypixelDataSource;
import fr.siroz.cariboustonks.core.data.hypixel.bazaar.Product;
import fr.siroz.cariboustonks.core.data.mod.SkyBlockAttribute;
import fr.siroz.cariboustonks.core.skyblock.AttributeAPI;
import fr.siroz.cariboustonks.core.skyblock.Rarity;
import fr.siroz.cariboustonks.core.skyblock.SkyBlockAPI;
import fr.siroz.cariboustonks.feature.Feature;
import fr.siroz.cariboustonks.manager.container.ContainerMatcherTrait;
import fr.siroz.cariboustonks.manager.container.tooltip.ContainerTooltipAppender;
import fr.siroz.cariboustonks.util.InventoryUtils;
import fr.siroz.cariboustonks.util.RomanNumeralUtils;
import fr.siroz.cariboustonks.util.StonksUtils;
import java.lang.runtime.SwitchBootstraps;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.class_124;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_437;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AttributeInfoTooltipFeature
extends Feature
implements ContainerMatcherTrait,
ContainerTooltipAppender {
    private static final Pattern NAME_AND_LEVEL_PATTERN = Pattern.compile(".*? ([IVX]+) \\(.*\\)");
    private static final Pattern OWNED_PATTERN = Pattern.compile("Owned: ([\\d,]+) Shards?");
    private static final Pattern LEVEL_PATTERN = Pattern.compile("Level: (\\d+)");
    private static final Pattern SYPHON_COUNT_PATTERN = Pattern.compile("Syphon (\\d+) more to level up!");
    private static final Pattern RARITY_PATTERN = Pattern.compile("Rarity: (COMMON|UNCOMMON|RARE|EPIC|LEGENDARY)");
    private static final Pattern PLACEHOLDER_PATTERN = Pattern.compile("");
    private final HypixelDataSource hypixelDataSource;
    private final int priority;

    public AttributeInfoTooltipFeature(int priority) {
        this.priority = priority;
        this.hypixelDataSource = CaribouStonks.core().getHypixelDataSource();
    }

    @Override
    public boolean isEnabled() {
        return SkyBlockAPI.isOnSkyBlock() && ConfigManager.getConfig().hunting.attributeInfos;
    }

    @Override
    @Nullable
    public Pattern getTitlePattern() {
        return AttributeAPI.SHARD_GUI_PATTERN;
    }

    @Override
    public void appendToTooltip(@Nullable class_1735 focusedSlot, @NotNull class_1799 item, @NotNull List<class_2561> lines) {
        String title;
        if (this.hypixelDataSource.isBazaarInUpdate()) {
            return;
        }
        class_437 currentScreen = class_310.method_1551().field_1755;
        if (focusedSlot == null || currentScreen == null || lines.isEmpty()) {
            return;
        }
        if (InventoryUtils.isEdgeSlot(focusedSlot.field_7874, 6)) {
            return;
        }
        String string = title = currentScreen.method_25440().getString();
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{"Hunting Box", "Attribute Menu"}, (Object)string, n)) {
            case 0: {
                this.handleHuntingBox(lines);
                break;
            }
            case 1: {
                this.handleAttributeMenu(lines);
                break;
            }
        }
    }

    @Override
    public int getPriority() {
        return this.priority;
    }

    private void handleHuntingBox(@NotNull List<class_2561> lines) {
        String levelStr = null;
        String ownedStr = null;
        String syphonCountStr = null;
        String rarityStr = null;
        String id = null;
        Matcher matcher = PLACEHOLDER_PATTERN.matcher("");
        for (class_2561 line : lines) {
            String lineText = line.getString();
            if (lineText.isEmpty()) continue;
            matcher.reset(lineText);
            if (levelStr == null && matcher.usePattern(NAME_AND_LEVEL_PATTERN).matches()) {
                levelStr = matcher.group(1);
                continue;
            }
            if (ownedStr == null && matcher.usePattern(OWNED_PATTERN).matches()) {
                ownedStr = matcher.group(1).replace(",", "");
                continue;
            }
            if (syphonCountStr == null && matcher.usePattern(SYPHON_COUNT_PATTERN).matches()) {
                syphonCountStr = matcher.group(1);
                continue;
            }
            if (!matcher.usePattern(AttributeAPI.RARITY_AND_ID_PATTERN).matches()) continue;
            rarityStr = matcher.group(1);
            id = matcher.group(2);
            break;
        }
        if (levelStr == null || ownedStr == null || rarityStr == null || id == null) {
            return;
        }
        int level = RomanNumeralUtils.parse(levelStr);
        if (level < 0 || level > 10) {
            return;
        }
        int owned = StonksUtils.toInt(ownedStr, -1);
        if (owned < 0) {
            return;
        }
        Rarity itemRarity = Rarity.valueOf(rarityStr.toUpperCase(Locale.ROOT));
        int shardsUntilMax = AttributeAPI.getShardsUntilMax(itemRarity, level + 1);
        if (shardsUntilMax < 0 || syphonCountStr == null) {
            return;
        }
        int syphonCount = StonksUtils.toInt(syphonCountStr, -1);
        if (syphonCount < 0) {
            return;
        }
        int required = shardsUntilMax + syphonCount;
        this.appendTooltip(lines, id, required, owned);
    }

    private void handleAttributeMenu(@NotNull List<class_2561> lines) {
        String id = null;
        String rarityStr = null;
        String levelStr = null;
        String syphonCountStr = null;
        Matcher matcher = PLACEHOLDER_PATTERN.matcher("");
        for (class_2561 line : lines) {
            String lineText = line.getString();
            if (lineText.isEmpty()) continue;
            matcher.reset(lineText);
            if (id == null && matcher.usePattern(AttributeAPI.SOURCE_PATTERN).matches()) {
                id = matcher.group("id");
                continue;
            }
            if (rarityStr == null && matcher.usePattern(RARITY_PATTERN).matches()) {
                rarityStr = matcher.group(1);
                continue;
            }
            if (levelStr == null && matcher.usePattern(LEVEL_PATTERN).matches()) {
                levelStr = matcher.group(1);
                continue;
            }
            if (!matcher.usePattern(SYPHON_COUNT_PATTERN).matches()) continue;
            syphonCountStr = matcher.group(1);
            break;
        }
        if (id == null || rarityStr == null || levelStr == null || syphonCountStr == null) {
            return;
        }
        int level = StonksUtils.toInt(levelStr, -1);
        if (level < 0) {
            return;
        }
        int syphonCount = StonksUtils.toInt(syphonCountStr, -1);
        if (syphonCount < 0) {
            return;
        }
        Rarity itemRarity = Rarity.valueOf(rarityStr.toUpperCase(Locale.ROOT));
        int shardsUntilMax = AttributeAPI.getShardsUntilMax(itemRarity, level + 1);
        if (shardsUntilMax < 0) {
            return;
        }
        int required = shardsUntilMax + syphonCount;
        this.appendTooltip(lines, id, required, 0);
    }

    private void appendTooltip(@NotNull List<class_2561> lines, String id, int required, int owned) {
        lines.add((class_2561)class_2561.method_43473().method_10852((class_2561)class_2561.method_43470((String)"Shards Until Maxed: ").method_27692(class_124.field_1060)).method_10852((class_2561)class_2561.method_43470((String)String.valueOf(required)).method_27692(class_124.field_1075)));
        SkyBlockAttribute attribute = CaribouStonks.core().getModDataSource().getAttributeById(id);
        if (attribute != null) {
            this.addTotalCost(lines, required - owned, attribute.skyBlockApiId());
        }
    }

    private void addTotalCost(List<class_2561> lines, int required, String skyBlockApiId) {
        if (required > 0 && this.hypixelDataSource.hasBazaarItem(skyBlockApiId)) {
            Optional<Product> product = this.hypixelDataSource.getBazaarItem(skyBlockApiId);
            if (product.isEmpty()) {
                lines.add((class_2561)class_2561.method_43470((String)"Bazaar item error.").method_27692(class_124.field_1061));
                return;
            }
            double price = BazaarItemAnalytics.buyPrice(product.get()) * (double)required;
            String priceDisplay = StonksUtils.INTEGER_NUMBERS.format(price);
            lines.add((class_2561)class_2561.method_43470((String)"Cost To Max: ").method_27692(class_124.field_1054).method_10852((class_2561)class_2561.method_43470((String)(priceDisplay + " Coins")).method_27692(class_124.field_1065)).method_10852((class_2561)class_2561.method_43470((String)" (").method_27692(class_124.field_1080)).method_10852((class_2561)class_2561.method_43470((String)StonksUtils.SHORT_FLOAT_NUMBERS.format(price)).method_27692(class_124.field_1065)).method_10852((class_2561)class_2561.method_43470((String)")").method_27692(class_124.field_1080)));
        }
    }
}

