/*
 * Decompiled with CFR 0.152.
 */
package fr.siroz.cariboustonks.feature.slayer;

import fr.siroz.cariboustonks.config.ConfigManager;
import fr.siroz.cariboustonks.core.skyblock.SkyBlockAPI;
import fr.siroz.cariboustonks.event.ChatEvents;
import fr.siroz.cariboustonks.feature.Feature;
import fr.siroz.cariboustonks.manager.slayer.SlayerManager;
import fr.siroz.cariboustonks.util.Client;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_3417;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Experimental
public class SlayerCocoonedWarningFeature
extends Feature {
    private static final Pattern COCOONED_BOSS_PATTERN = Pattern.compile("YOU COCOONED YOUR SLAYER BOSS");
    private final SlayerManager slayerManager;

    public SlayerCocoonedWarningFeature(SlayerManager slayerManager) {
        this.slayerManager = slayerManager;
        ChatEvents.MESSAGE_RECEIVED.register(this::onMessage);
    }

    @Override
    public boolean isEnabled() {
        return SkyBlockAPI.isOnSkyBlock() && this.slayerManager.isInQuest() && ConfigManager.getConfig().slayer.slayerBossCocoonedWarning;
    }

    private void onMessage(@NotNull class_2561 text) {
        if (!this.isEnabled()) {
            return;
        }
        String message = text.getString();
        Matcher cocoonBossMatcher = COCOONED_BOSS_PATTERN.matcher(message = message.replaceFirst("^\\s+", ""));
        if (cocoonBossMatcher.matches()) {
            Client.showTitle((class_2561)class_2561.method_43470((String)"Slayer Boss Cocooned!").method_27695(new class_124[]{class_124.field_1061, class_124.field_1067}), 1, 60, 1);
            Client.playSound(class_3417.field_15203, 1.0f, 1.0f);
        }
    }
}

