/*
 * Decompiled with CFR 0.152.
 */
package fr.siroz.cariboustonks.feature.stonks.info;

import fr.siroz.cariboustonks.config.ConfigManager;
import fr.siroz.cariboustonks.core.data.algo.BazaarItemAnalytics;
import fr.siroz.cariboustonks.core.data.hypixel.bazaar.Product;
import fr.siroz.cariboustonks.core.data.hypixel.bazaar.Summary;
import fr.siroz.cariboustonks.feature.stonks.AbstractItemStonksWidget;
import fr.siroz.cariboustonks.util.StonksUtils;
import fr.siroz.cariboustonks.util.colors.Colors;
import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_5250;
import org.jetbrains.annotations.Nullable;

public class ItemInformationWidget
extends AbstractItemStonksWidget {
    private boolean bazaar;
    private double buyPrice;
    private double sellPrice;
    private double buyAvg;
    private double sellAvg;
    private double buyMedian;
    private double sellMedian;
    private long buyVolume;
    private long sellVolume;
    private long buyOrders;
    private long sellOrders;
    private long buyMovingWeek;
    private long sellMovingWeek;
    private double spreadPercentage;
    private double orderImbalancePercentage;
    private double vwap;
    private double standardDeviationBuy;
    private double standardDeviationSell;
    private double sellSideLiquiditySlope;

    public ItemInformationWidget(@Nullable Product bazaarItem, int width, int height) {
        super(width, height);
        if (bazaarItem != null) {
            this.bazaar = true;
            this.buyPrice = BazaarItemAnalytics.buyPrice(bazaarItem);
            this.sellPrice = BazaarItemAnalytics.sellPrice(bazaarItem);
            this.buyAvg = BazaarItemAnalytics.weightedAverageBuyPrice(bazaarItem);
            this.sellAvg = BazaarItemAnalytics.weightedAverageSellPrice(bazaarItem);
            List<Double> buyPrices = bazaarItem.buySummary().stream().map(Summary::pricePerUnit).toList();
            List<Double> sellPrices = bazaarItem.sellSummary().stream().map(Summary::pricePerUnit).toList();
            this.buyMedian = StonksUtils.calculateMedian(buyPrices);
            this.sellMedian = StonksUtils.calculateMedian(sellPrices);
            this.buyVolume = bazaarItem.quickStatus().buyVolume();
            this.sellVolume = bazaarItem.quickStatus().sellVolume();
            this.buyOrders = bazaarItem.quickStatus().buyOrders();
            this.sellOrders = bazaarItem.quickStatus().sellOrders();
            this.buyMovingWeek = bazaarItem.quickStatus().buyMovingWeek();
            this.sellMovingWeek = bazaarItem.quickStatus().sellMovingWeek();
            this.spreadPercentage = BazaarItemAnalytics.spreadPercentage(bazaarItem);
            this.orderImbalancePercentage = BazaarItemAnalytics.orderImbalancePercentage(bazaarItem);
            this.vwap = BazaarItemAnalytics.vwap(bazaarItem);
            this.standardDeviationBuy = BazaarItemAnalytics.standardDeviation(bazaarItem.buySummary());
            this.standardDeviationSell = BazaarItemAnalytics.standardDeviation(bazaarItem.sellSummary());
            this.sellSideLiquiditySlope = BazaarItemAnalytics.calculateSellSideLiquiditySlope(bazaarItem, 95.0);
        }
    }

    @Override
    public void render(class_332 context, int mouseX, int mouseY, int x, int y) {
        if (this.bazaar) {
            class_5250 textBuy = class_2561.method_43470((String)"Buy Price: ").method_27692(class_124.field_1054).method_10852((class_2561)class_2561.method_43470((String)StonksUtils.INTEGER_NUMBERS.format(this.buyPrice)).method_27692(class_124.field_1065)).method_10852((class_2561)class_2561.method_43470((String)" (").method_27692(class_124.field_1080)).method_10852((class_2561)class_2561.method_43470((String)StonksUtils.SHORT_FLOAT_NUMBERS.format(this.buyPrice)).method_27692(class_124.field_1065)).method_10852((class_2561)class_2561.method_43470((String)")").method_27692(class_124.field_1080));
            context.method_27535(this.textRenderer, (class_2561)textBuy, x + 20, y + 20, Colors.WHITE.asInt());
            class_5250 textAvgBuy = class_2561.method_43470((String)"Avg. Price: ").method_27692(class_124.field_1054).method_10852((class_2561)class_2561.method_43470((String)StonksUtils.SHORT_FLOAT_NUMBERS.format(this.buyAvg)).method_27692(class_124.field_1065));
            context.method_27535(this.textRenderer, (class_2561)textAvgBuy, x + 20, y + 30, Colors.WHITE.asInt());
            class_5250 textBuyMedian = class_2561.method_43470((String)"*Median Price: ").method_27692(class_124.field_1054).method_10852((class_2561)class_2561.method_43470((String)StonksUtils.SHORT_FLOAT_NUMBERS.format(this.buyMedian)).method_27692(class_124.field_1065));
            context.method_27535(this.textRenderer, (class_2561)textBuyMedian, x + 20, y + 40, Colors.WHITE.asInt());
            class_5250 textBuyOrderInfos = class_2561.method_43470((String)StonksUtils.SHORT_FLOAT_NUMBERS.format(this.buyVolume)).method_27692(class_124.field_1063).method_27693(" in " + StonksUtils.SHORT_FLOAT_NUMBERS.format(this.buyOrders) + " orders");
            context.method_27535(this.textRenderer, (class_2561)textBuyOrderInfos, x + 20, y + 55, Colors.WHITE.asInt());
            class_5250 textBuyMoving = class_2561.method_43470((String)StonksUtils.SHORT_FLOAT_NUMBERS.format(this.buyMovingWeek)).method_27692(class_124.field_1063).method_10852((class_2561)class_2561.method_43470((String)" insta-buys in 7d"));
            context.method_27535(this.textRenderer, (class_2561)textBuyMoving, x + 20, y + 65, Colors.WHITE.asInt());
            class_5250 textSell = class_2561.method_43470((String)"Sell Price: ").method_27692(class_124.field_1054).method_10852((class_2561)class_2561.method_43470((String)StonksUtils.INTEGER_NUMBERS.format(this.sellPrice)).method_27692(class_124.field_1065)).method_10852((class_2561)class_2561.method_43470((String)" (").method_27692(class_124.field_1080)).method_10852((class_2561)class_2561.method_43470((String)StonksUtils.SHORT_FLOAT_NUMBERS.format(this.sellPrice)).method_27692(class_124.field_1065)).method_10852((class_2561)class_2561.method_43470((String)")").method_27692(class_124.field_1080));
            context.method_27535(this.textRenderer, (class_2561)textSell, x + 20, y + 80, Colors.WHITE.asInt());
            class_5250 textAvgSell = class_2561.method_43470((String)"Avg. Price: ").method_27692(class_124.field_1054).method_10852((class_2561)class_2561.method_43470((String)StonksUtils.SHORT_FLOAT_NUMBERS.format(this.sellAvg)).method_27692(class_124.field_1065));
            context.method_27535(this.textRenderer, (class_2561)textAvgSell, x + 20, y + 90, Colors.WHITE.asInt());
            class_5250 textSellMedian = class_2561.method_43470((String)"*Median Price: ").method_27692(class_124.field_1054).method_10852((class_2561)class_2561.method_43470((String)StonksUtils.SHORT_FLOAT_NUMBERS.format(this.sellMedian)).method_27692(class_124.field_1065));
            context.method_27535(this.textRenderer, (class_2561)textSellMedian, x + 20, y + 100, Colors.WHITE.asInt());
            class_5250 textSellOrderInfos = class_2561.method_43470((String)StonksUtils.SHORT_FLOAT_NUMBERS.format(this.sellVolume)).method_27692(class_124.field_1063).method_27693(" in " + StonksUtils.SHORT_FLOAT_NUMBERS.format(this.sellOrders) + " orders");
            context.method_27535(this.textRenderer, (class_2561)textSellOrderInfos, x + 20, y + 115, Colors.WHITE.asInt());
            class_5250 textSellMoving = class_2561.method_43470((String)StonksUtils.SHORT_FLOAT_NUMBERS.format(this.sellMovingWeek)).method_27692(class_124.field_1063).method_10852((class_2561)class_2561.method_43470((String)" insta-sells in 7d"));
            context.method_27535(this.textRenderer, (class_2561)textSellMoving, x + 20, y + 125, Colors.WHITE.asInt());
            if (ConfigManager.getConfig().general.stonks.showAllDataInInfoScreen) {
                class_5250 textSpread = class_2561.method_43470((String)"*Spread: ").method_27692(class_124.field_1061).method_27693(StonksUtils.FLOAT_NUMBERS.format(this.spreadPercentage) + " %").method_27692(class_124.field_1061);
                context.method_27535(this.textRenderer, (class_2561)textSpread, x + 20, y + 145, Colors.WHITE.asInt());
                class_5250 textImbalance = class_2561.method_43470((String)"*Imbalance: ").method_27692(class_124.field_1064).method_10852((class_2561)class_2561.method_43470((String)(StonksUtils.FLOAT_NUMBERS.format(this.orderImbalancePercentage) + " %")).method_27692(class_124.field_1076));
                context.method_27535(this.textRenderer, (class_2561)textImbalance, x + 20, y + 155, Colors.WHITE.asInt());
                class_5250 textVWAP = class_2561.method_43470((String)"*VWAP: ").method_27692(class_124.field_1076).method_10852((class_2561)class_2561.method_43470((String)StonksUtils.SHORT_FLOAT_NUMBERS.format(this.vwap)).method_27692(class_124.field_1064));
                context.method_27535(this.textRenderer, (class_2561)textVWAP, x + 20, y + 165, Colors.WHITE.asInt());
                class_5250 textSellOrderSlope = class_2561.method_43470((String)"*Sell Orders Slope: ").method_27692(class_124.field_1078);
                context.method_27535(this.textRenderer, (class_2561)textSellOrderSlope, x + 20, y + 175, Colors.WHITE.asInt());
                class_5250 textSellOrderSlopeValue = class_2561.method_43470((String)("+~ " + StonksUtils.DOUBLE_NUMBERS.format(this.sellSideLiquiditySlope))).method_27692(class_124.field_1075);
                context.method_27535(this.textRenderer, (class_2561)textSellOrderSlopeValue, x + 20, y + 185, Colors.WHITE.asInt());
                class_5250 textStandardDeviation = class_2561.method_43470((String)"*Standard Deviation: ").method_27692(class_124.field_1079);
                context.method_27535(this.textRenderer, (class_2561)textStandardDeviation, x + 20, y + 195, Colors.WHITE.asInt());
                class_5250 textStandardDeviationValues = class_2561.method_43470((String)("Buy: " + StonksUtils.SHORT_FLOAT_NUMBERS.format(this.standardDeviationBuy) + " | Sell: " + StonksUtils.SHORT_FLOAT_NUMBERS.format(this.standardDeviationSell))).method_27692(class_124.field_1061);
                context.method_27535(this.textRenderer, (class_2561)textStandardDeviationValues, x + 20, y + 205, Colors.WHITE.asInt());
            }
            class_5250 warningInfo = class_2561.method_43470((String)"* Not a true representation of all orders.").method_27695(new class_124[]{class_124.field_1063, class_124.field_1056});
            context.method_27535(this.textRenderer, (class_2561)warningInfo, x + 20, y + 225, Colors.WHITE.asInt());
        }
    }
}

