/*
 * Decompiled with CFR 0.152.
 */
package fr.siroz.cariboustonks.feature.stonks.search;

import fr.siroz.cariboustonks.CaribouStonks;
import fr.siroz.cariboustonks.core.data.hypixel.HypixelDataException;
import fr.siroz.cariboustonks.core.data.hypixel.HypixelDataSource;
import fr.siroz.cariboustonks.core.data.hypixel.SkyBlockItem;
import fr.siroz.cariboustonks.core.data.item.ItemLookupKey;
import fr.siroz.cariboustonks.feature.stonks.StonksScreen;
import fr.siroz.cariboustonks.feature.stonks.search.ItemSummary;
import fr.siroz.cariboustonks.feature.stonks.search.StonksSearchScreen;
import fr.siroz.cariboustonks.util.Client;
import fr.siroz.cariboustonks.util.NotEnoughUpdatesUtils;
import fr.siroz.cariboustonks.util.StonksUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import net.minecraft.class_124;
import net.minecraft.class_156;
import net.minecraft.class_1799;
import net.minecraft.class_1921;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_350;
import net.minecraft.class_4280;
import net.minecraft.class_437;
import net.minecraft.class_5348;
import net.minecraft.class_7413;
import net.minecraft.class_8494;
import org.jetbrains.annotations.Nullable;

public class ItemListWidget
extends class_4280<Entry> {
    private final StonksSearchScreen parent;
    public static final class_2960 HIGHLIGHTED_TEXTURE = class_2960.method_60656((String)"world_list/join_highlighted");
    public static final class_2960 TEXTURE = class_2960.method_60656((String)"world_list/join");
    private final CompletableFuture<List<ItemSummary>> itemsFuture;
    private List<ItemSummary> items;
    private String search;
    static boolean loadingSearch;
    private final LoadingEntry loadingEntry;

    public ItemListWidget(StonksSearchScreen parent, class_310 client, int width, int height, int y, int itemHeight, String search) {
        super(client, width, height, y, itemHeight);
        this.parent = parent;
        this.loadingEntry = new LoadingEntry(client);
        this.search = search;
        loadingSearch = false;
        this.itemsFuture = this.loadItems();
        this.show(this.tryGet());
    }

    private CompletableFuture<List<ItemSummary>> loadItems() {
        try {
            HypixelDataSource hypixelDataSource = CaribouStonks.core().getHypixelDataSource();
            List<SkyBlockItem> itemList = hypixelDataSource.getSkyBlockItems();
            return CompletableFuture.supplyAsync(() -> {
                ArrayList<ItemSummary> itemSummaries = new ArrayList<ItemSummary>(itemList.size());
                for (SkyBlockItem item : itemList) {
                    String skyBlockId = item.getSkyBlockId();
                    class_124 formatting = item.getTier().getFormatting();
                    String name = item.getName();
                    class_1799 itemStack = hypixelDataSource.getItemStack(skyBlockId);
                    ItemSummary summary = new ItemSummary(skyBlockId, formatting, name, itemStack);
                    itemSummaries.add(summary);
                }
                return itemSummaries;
            });
        }
        catch (HypixelDataException exception) {
            StonksUtils.showFatalErrorScreen((class_2561)class_2561.method_43470((String)"Unable to load items!"), exception.getMessageText());
            return CompletableFuture.completedFuture(Collections.emptyList());
        }
    }

    public int method_25322() {
        return 270;
    }

    protected void method_25339() {
        this.method_25396().forEach(Entry::close);
        super.method_25339();
    }

    @Nullable
    private List<ItemSummary> tryGet() {
        try {
            return this.itemsFuture.getNow(null);
        }
        catch (CancellationException | CompletionException exception) {
            return null;
        }
    }

    public void method_48579(class_332 context, int mouseX, int mouseY, float delta) {
        List<ItemSummary> itemsList = this.tryGet();
        if (itemsList != this.items) {
            this.show(itemsList);
        }
        super.method_48579(context, mouseX, mouseY, delta);
    }

    private void show(@Nullable List<ItemSummary> items) {
        if (items == null) {
            this.showLoadingScreen();
        } else {
            this.showSummaries(this.search, items);
        }
        this.items = items;
    }

    public void setSearch(String search) {
        if (this.items != null && !search.equals(this.search)) {
            this.showSummaries(search, this.items);
        }
        this.search = search;
    }

    private void showSummaries(String search, List<ItemSummary> summaries) {
        this.method_25339();
        search = search.toLowerCase(Locale.ROOT);
        for (ItemSummary itemSummary : summaries) {
            if (!this.shouldShow(search, itemSummary)) continue;
            this.method_25321((class_350.class_351)new ItemEntry(this, itemSummary));
        }
    }

    private boolean shouldShow(String search, ItemSummary summary) {
        return summary.name().toLowerCase(Locale.ROOT).contains(search) || summary.hypixelSkyBlockId().toLowerCase(Locale.ROOT).contains(search);
    }

    private void showLoadingScreen() {
        this.method_25339();
        this.method_25321((class_350.class_351)this.loadingEntry);
    }

    public void setSelected(@Nullable Entry entry) {
        super.method_25313((class_350.class_351)entry);
        ItemSummary item = null;
        if (entry instanceof ItemEntry) {
            ItemEntry itemEntry = (ItemEntry)entry;
            item = itemEntry.item;
        }
        this.parent.itemSelected(item);
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        Optional<ItemEntry> itemEntry;
        if (class_8494.method_51255((int)keyCode) && (itemEntry = this.getSelectedOptional()).isPresent()) {
            Client.playSoundButtonClickUI();
            itemEntry.get().load();
            return true;
        }
        return super.method_25404(keyCode, scanCode, modifiers);
    }

    public Optional<ItemEntry> getSelectedOptional() {
        Entry entry = (Entry)this.method_25334();
        if (entry instanceof ItemEntry) {
            ItemEntry itemEntry = (ItemEntry)entry;
            return Optional.of(itemEntry);
        }
        return Optional.empty();
    }

    public static class LoadingEntry
    extends Entry {
        private static final class_2561 LOADING_LIST_TEXT = class_2561.method_43470((String)"Loading..");
        private final class_310 client;

        public LoadingEntry(class_310 client) {
            this.client = client;
        }

        public void method_25343(class_332 context, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean hovered, float tickDelta) {
            if (this.client == null || this.client.field_1755 == null || this.client.field_1772 == null) {
                return;
            }
            int x1 = (this.client.field_1755.field_22789 - this.client.field_1772.method_27525((class_5348)LOADING_LIST_TEXT)) / 2;
            int y1 = y + (entryHeight - 9) / 2;
            context.method_27535(this.client.field_1772, LOADING_LIST_TEXT, x1, y1, -1);
            String string = class_7413.method_43449((long)class_156.method_658());
            int x2 = (this.client.field_1755.field_22789 - this.client.field_1772.method_1727(string)) / 2;
            int y2 = y1 + 9;
            context.method_25303(this.client.field_1772, string, x2, y2, -8355712);
        }

        public class_2561 method_37006() {
            return LOADING_LIST_TEXT;
        }
    }

    public class ItemEntry
    extends Entry {
        private final class_310 client;
        private final ItemSummary item;
        private long time;

        public ItemEntry(ItemListWidget itemList, ItemSummary item) {
            this.client = itemList.field_22740;
            this.item = item;
        }

        public class_2561 method_37006() {
            return class_2561.method_43470((String)("Select " + this.item.name()));
        }

        public void method_25343(class_332 context, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean hovered, float tickDelta) {
            if (this.client == null || this.client.field_1772 == null) {
                return;
            }
            String displayName = this.item.name();
            String name = this.item.hypixelSkyBlockId();
            int color = this.item.color().method_532() == null ? -1 : this.item.color().method_532();
            context.method_25303(this.client.field_1772, displayName, x + 32 + 3, y + 1, color);
            int x1 = x + 32 + 3;
            context.method_25303(this.client.field_1772, name, x1, y + 9 + 3, -8355712);
            if (hovered) {
                context.method_25294(x, y, x + 32, y + 32, -1601138544);
                int x2 = mouseX - x;
                if (x2 < 32) {
                    context.method_52706(class_1921::method_62277, HIGHLIGHTED_TEXTURE, x, y, 32, 32);
                } else {
                    context.method_51427(this.item.icon(), x + 7, y + 7);
                    context.method_52706(class_1921::method_62277, TEXTURE, x, y, 32, 32);
                }
            } else {
                context.method_51427(this.item.icon(), x + 7, y + 7);
            }
        }

        public boolean method_25402(double mouseX, double mouseY, int button) {
            ItemListWidget.this.setSelected(this);
            if (!(mouseX - (double)ItemListWidget.this.method_25342() <= 32.0) && class_156.method_658() - this.time >= 1000L) {
                this.time = class_156.method_658();
                return super.method_25402(mouseX, mouseY, button);
            }
            Client.playSoundButtonClickUI();
            this.load();
            return true;
        }

        public void load() {
            if (loadingSearch) {
                return;
            }
            loadingSearch = true;
            if (this.client.field_1724 != null) {
                this.client.method_1507((class_437)new StonksScreen(ItemLookupKey.of(NotEnoughUpdatesUtils.getNeuIdFromSkyBlockId(this.item.hypixelSkyBlockId()), this.item.hypixelSkyBlockId())));
            }
        }
    }

    public static abstract class Entry
    extends class_4280.class_4281<Entry>
    implements AutoCloseable {
        @Override
        public void close() {
        }
    }
}

