/*
 * Decompiled with CFR 0.152.
 */
package fr.siroz.cariboustonks.manager.glowing;

import fr.siroz.cariboustonks.feature.Feature;
import fr.siroz.cariboustonks.manager.Manager;
import fr.siroz.cariboustonks.manager.glowing.EntityGlowProvider;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.HashMap;
import java.util.Map;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.minecraft.class_1297;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class GlowingManager
implements Manager {
    private final Map<Feature, EntityGlowProvider> entitiesGlow = new HashMap<Feature, EntityGlowProvider>();
    private final Object2IntMap<class_1297> cachedEntities = new Object2IntOpenHashMap();

    @ApiStatus.Internal
    public GlowingManager() {
        ClientTickEvents.END_WORLD_TICK.register(_client -> this.cachedEntities.clear());
    }

    @Override
    public void register(@NotNull Feature feature) {
        if (feature instanceof EntityGlowProvider) {
            EntityGlowProvider glowing = (EntityGlowProvider)((Object)feature);
            this.entitiesGlow.put(feature, glowing);
        }
    }

    public int getEntityColorOrDefault(@Nullable class_1297 entity, int defaultColor) {
        if (entity == null) {
            return defaultColor;
        }
        return this.cachedEntities.getOrDefault((Object)entity, defaultColor);
    }

    public boolean hasOrComputeEntity(@Nullable class_1297 entity) {
        if (entity == null) {
            return false;
        }
        if (this.cachedEntities.containsKey((Object)entity)) {
            return true;
        }
        int color = this.computeEntity(entity);
        if (color != 0) {
            this.cachedEntities.put((Object)entity, color);
            return true;
        }
        return false;
    }

    private int computeEntity(@NotNull class_1297 entity) {
        for (Map.Entry<Feature, EntityGlowProvider> entry : this.entitiesGlow.entrySet()) {
            int glowColor;
            if (!entry.getKey().isEnabled() || (glowColor = entry.getValue().getEntityGlowColor(entity)) == 0) continue;
            return glowColor;
        }
        return 0;
    }
}

