/*
 * Decompiled with CFR 0.152.
 */
package fr.siroz.cariboustonks.manager.keybinds;

import fr.siroz.cariboustonks.CaribouStonks;
import fr.siroz.cariboustonks.core.crash.CrashType;
import fr.siroz.cariboustonks.event.CustomScreenEvents;
import fr.siroz.cariboustonks.feature.Feature;
import fr.siroz.cariboustonks.manager.Manager;
import fr.siroz.cariboustonks.manager.keybinds.KeyBind;
import fr.siroz.cariboustonks.manager.keybinds.KeyBindComponent;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.keybinding.v1.KeyBindingHelper;
import net.minecraft.class_1735;
import net.minecraft.class_304;
import net.minecraft.class_437;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

public final class KeyBindManager
implements Manager {
    private final Set<KeyBind> enabledKeyBinds = ConcurrentHashMap.newKeySet();
    private final Map<Feature, List<KeyBind>> keyBinds = new ConcurrentHashMap<Feature, List<KeyBind>>();

    @ApiStatus.Internal
    public KeyBindManager() {
        ClientTickEvents.END_CLIENT_TICK.register(_client -> this.triggerKeyBinds());
        CustomScreenEvents.KEY_PRESSED.register(this::handleKeyPressed);
    }

    @Override
    public void register(@NotNull Feature feature) {
        feature.getComponent(KeyBindComponent.class).ifPresent(keyBindComponent -> this.register(feature, (KeyBindComponent)keyBindComponent));
    }

    private void handleKeyPressed(class_437 screen, int keyCode, int scanCode, @NotNull class_1735 slot) {
        this.triggerKeyBindsInScreen(screen, keyCode, scanCode, slot);
    }

    private void register(Feature feature, KeyBindComponent keyBindComponent) {
        try {
            this.keyBinds.putIfAbsent(feature, new LinkedList());
            this.keyBinds.get(feature).addAll(keyBindComponent.keyBinds());
        }
        catch (Exception ex) {
            CaribouStonks.LOGGER.error("[KeyBindManager] Failed to register KeyBinds in {}", (Object)feature.getClass().getName(), (Object)ex);
        }
        this.enableFeatureKeyBinds(feature);
    }

    private void enableFeatureKeyBinds(@NotNull Feature feature) {
        if (!this.keyBinds.containsKey(feature)) {
            return;
        }
        for (KeyBind keyBind : this.keyBinds.get(feature)) {
            this.registerKeyBind(keyBind);
        }
    }

    private void registerKeyBind(KeyBind keyBind) {
        if (this.enabledKeyBinds.stream().anyMatch(k -> k.getName().equals(keyBind.getName()))) {
            throw new IllegalStateException("Unable to add KeyBind '" + keyBind.getName() + "' name already exists");
        }
        this.enabledKeyBinds.add(keyBind);
        KeyBindingHelper.registerKeyBinding((class_304)keyBind.getKeyBinding());
    }

    private void triggerKeyBinds() {
        this.checkAllKeyBinds(keyBind -> {
            if (keyBind.isFirstPress()) {
                if (keyBind.getKeyBinding().method_1434() && !keyBind.isPressed()) {
                    keyBind.onPress();
                }
                keyBind.setPressed(keyBind.getKeyBinding().method_1434());
            } else if (keyBind.getKeyBinding().method_1434()) {
                keyBind.onPress();
            }
        });
    }

    private void checkAllKeyBinds(Consumer<KeyBind> checkKeyBind) {
        for (Feature feature : this.keyBinds.keySet()) {
            for (KeyBind keyBind : this.keyBinds.get(feature)) {
                if (keyBind.hasScreenPressHandler()) continue;
                try {
                    checkKeyBind.accept(keyBind);
                }
                catch (Throwable throwable) {
                    CaribouStonks.core().reportCrash(CrashType.KEYBINDING, keyBind.getName(), feature.getClass().getName() + "." + keyBind.getName(), "handling", throwable);
                }
            }
        }
    }

    private void triggerKeyBindsInScreen(class_437 screen, int keyCode, int scanCode, class_1735 slot) {
        for (Feature feature : this.keyBinds.keySet()) {
            for (KeyBind keyBind : this.keyBinds.get(feature)) {
                try {
                    if (!keyBind.hasScreenPressHandler() || !keyBind.getKeyBinding().method_1417(keyCode, scanCode)) continue;
                    keyBind.onScreenPress(screen, slot);
                }
                catch (Throwable throwable) {
                    CaribouStonks.core().reportCrash(CrashType.KEYBINDING, keyBind.getName(), feature.getClass().getName() + "." + keyBind.getName(), "handling in screen", throwable);
                }
            }
        }
    }
}

