/*
 * Decompiled with CFR 0.152.
 */
package fr.siroz.cariboustonks.manager.reminder;

import fr.siroz.cariboustonks.CaribouStonks;
import fr.siroz.cariboustonks.core.scheduler.TickScheduler;
import fr.siroz.cariboustonks.event.SkyBlockEvents;
import fr.siroz.cariboustonks.feature.Feature;
import fr.siroz.cariboustonks.manager.Manager;
import fr.siroz.cariboustonks.manager.reminder.Reminder;
import fr.siroz.cariboustonks.manager.reminder.TimedObject;
import fr.siroz.cariboustonks.util.DeveloperTools;
import it.unimi.dsi.fastutil.Pair;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.PriorityQueue;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

public final class ReminderManager
implements Manager {
    private static final Path REMAINDER_PATH = CaribouStonks.CONFIG_DIR.resolve("reminder.json");
    private final PriorityQueue<TimedObject> queue = new PriorityQueue<TimedObject>(Comparator.comparing(TimedObject::expirationTime));
    private final Set<String> preNotifiedSet = ConcurrentHashMap.newKeySet();
    private final Map<String, TimedObject> objectSet = new ConcurrentHashMap<String, TimedObject>();
    private final Object2ObjectMap<Feature, Reminder> reminders = new Object2ObjectOpenHashMap();
    private final ScheduledExecutorService scheduler = Executors.newScheduledThreadPool(1);
    private boolean loaded = false;

    @ApiStatus.Internal
    public ReminderManager() {
        SkyBlockEvents.JOIN.register(_serverName -> this.onSkyBlockJoin());
        this.startMonitoring();
    }

    @Override
    public void register(@NotNull Feature feature) {
        if (feature instanceof Reminder) {
            Reminder reminder = (Reminder)((Object)feature);
            this.reminders.put((Object)feature, (Object)reminder);
        }
    }

    public void addTimedObject(@NotNull TimedObject obj) {
        this.addTimedObject(obj, false);
    }

    public void addTimedObject(@NotNull TimedObject obj, boolean replaceIfExists) {
        if (this.objectSet.containsKey(obj.id())) {
            if (replaceIfExists) {
                this.queue.removeIf(o -> o.id().equals(obj.id()));
                this.objectSet.remove(obj.id());
            } else {
                return;
            }
        }
        this.queue.add(obj);
        this.objectSet.put(obj.id(), obj);
        if (DeveloperTools.isInDevelopment()) {
            if (replaceIfExists) {
                CaribouStonks.LOGGER.info("[ReminderManager] Updated {}", (Object)obj.id());
            } else {
                CaribouStonks.LOGGER.info("[ReminderManager] Added {}", (Object)obj.id());
            }
        }
    }

    @NotNull
    public List<Pair<Reminder, TimedObject>> getReminders() {
        ArrayList<Pair<Reminder, TimedObject>> reminderList = new ArrayList<Pair<Reminder, TimedObject>>();
        for (TimedObject obj : this.queue) {
            this.reminders.values().stream().filter(v -> v.reminderType().equals(obj.type())).map(v -> Pair.of((Object)v, (Object)obj)).findFirst().ifPresent(reminderList::add);
        }
        reminderList.sort(Comparator.comparing(pair -> ((TimedObject)pair.right()).expirationTime()));
        return reminderList;
    }

    private void onSkyBlockJoin() {
        if (this.loaded) {
            return;
        }
        this.loaded = true;
        this.loadTimedObjects().thenAccept(timedObjects -> TickScheduler.getInstance().runLater(() -> this.loadExistingObjects((List<TimedObject>)timedObjects), 2, TimeUnit.SECONDS));
    }

    @Override
    public void onShutdown() {
        if (!this.loaded) {
            return;
        }
        this.loaded = false;
        ArrayList<TimedObject> objectsList = !this.queue.isEmpty() ? new ArrayList<TimedObject>(this.queue) : List.of();
        CaribouStonks.core().getJsonFileService().save(REMAINDER_PATH, objectsList);
    }

    @NotNull
    private CompletableFuture<List<TimedObject>> loadTimedObjects() {
        if (!Files.exists(REMAINDER_PATH, new LinkOption[0])) {
            return CompletableFuture.completedFuture(List.of());
        }
        return CompletableFuture.supplyAsync(() -> CaribouStonks.core().getJsonFileService().loadList(REMAINDER_PATH, TimedObject.class));
    }

    private void loadExistingObjects(@NotNull List<TimedObject> loadedObjects) {
        CaribouStonks.LOGGER.info("[Reminder] Loading {} TimedObject", (Object)loadedObjects.size());
        Instant now = Instant.now();
        for (TimedObject obj : loadedObjects) {
            if (obj.expirationTime().isBefore(now)) {
                this.onExpire(obj);
                continue;
            }
            this.queue.add(obj);
        }
    }

    private void startMonitoring() {
        this.scheduler.scheduleAtFixedRate(() -> {
            Instant now = Instant.now();
            ArrayList<TimedObject> expiredObjects = new ArrayList<TimedObject>();
            PriorityQueue<TimedObject> priorityQueue = this.queue;
            synchronized (priorityQueue) {
                this.queue.stream().map(obj -> this.getReminder((TimedObject)obj).map(r -> Map.entry(obj, r))).filter(Optional::isPresent).map(Optional::get).filter(entry -> ((Reminder)entry.getValue()).preNotifyDuration().isPresent()).filter(entry -> this.preNotifiedSet.add(((TimedObject)entry.getKey()).id())).forEach(entry -> {
                    TimedObject obj = (TimedObject)entry.getKey();
                    Reminder reminder = (Reminder)entry.getValue();
                    if (reminder.preNotifyDuration().isPresent()) {
                        Instant preNotifyTime = obj.expirationTime().minus(reminder.preNotifyDuration().get());
                        if (!now.isBefore(preNotifyTime)) {
                            reminder.onPreExpire(obj);
                        } else {
                            this.preNotifiedSet.remove(obj.id());
                        }
                    }
                });
                while (!this.queue.isEmpty() && this.queue.peek().expirationTime().isBefore(now)) {
                    expiredObjects.add(this.queue.poll());
                }
            }
            expiredObjects.forEach(obj -> {
                this.objectSet.remove(obj.id());
                this.preNotifiedSet.remove(obj.id());
                this.onExpire((TimedObject)obj);
            });
        }, 10L, 10L, TimeUnit.SECONDS);
    }

    @NotNull
    private Optional<Reminder> getReminder(@NotNull TimedObject timedObject) {
        return this.reminders.values().stream().filter(r -> r.reminderType().equals(timedObject.type())).findFirst();
    }

    private void onExpire(@NotNull TimedObject timedObject) {
        this.reminders.values().stream().filter(reminder -> reminder.reminderType().equals(timedObject.type())).findFirst().ifPresent(reminder -> reminder.onExpire(timedObject));
    }
}

