/*
 * Decompiled with CFR 0.152.
 */
package fr.siroz.cariboustonks.manager.slayer;

import fr.siroz.cariboustonks.event.SkyBlockEvents;
import fr.siroz.cariboustonks.manager.slayer.SlayerManager;
import fr.siroz.cariboustonks.manager.slayer.SlayerTier;
import fr.siroz.cariboustonks.manager.slayer.SlayerType;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1531;
import org.jetbrains.annotations.NotNull;

class SlayerQuest {
    private final SlayerManager slayerManager;
    private SlayerType slayerType;
    private SlayerTier slayerTier;
    private final List<class_1531> minibossesArmorStand = new ArrayList<class_1531>();
    private final List<class_1297> minibosses = new ArrayList<class_1297>();

    SlayerQuest(SlayerManager slayerManager) {
        this.slayerManager = slayerManager;
        this.slayerType = SlayerType.UNKNOWN;
        this.slayerTier = SlayerTier.UNKNOWN;
    }

    public void onMinibossSpawn(@NotNull class_1531 armorStand, @NotNull SlayerType type) {
        if (!this.minibossesArmorStand.contains(armorStand)) {
            this.minibossesArmorStand.add(armorStand);
            if (this.slayerTier == SlayerTier.V && !type.getMinibossEntityTypes().isEmpty()) {
                for (class_1299<? extends class_1297> minibossEntityType : type.getMinibossEntityTypes()) {
                    class_1297 closestEntity = this.slayerManager.findClosestEntity(minibossEntityType, armorStand);
                    if (closestEntity == null) continue;
                    this.minibosses.add(closestEntity);
                    break;
                }
            } else {
                this.minibosses.add(this.slayerManager.findClosestEntity(type.getEntityType(), armorStand));
            }
            ((SkyBlockEvents.SlayerMinibossSpawn)SkyBlockEvents.SLAYER_MINIBOSS_SPAWN.invoker()).onSpawn(type, this.slayerTier);
        }
    }

    public SlayerType getSlayerType() {
        return this.slayerType;
    }

    public void setSlayerType(SlayerType slayerType) {
        this.slayerType = slayerType;
    }

    public SlayerTier getSlayerTier() {
        return this.slayerTier;
    }

    public void setSlayerTier(SlayerTier slayerTier) {
        this.slayerTier = slayerTier;
    }

    public List<class_1297> getMinibosses() {
        return this.minibosses;
    }
}

