/*
 * Decompiled with CFR 0.152.
 */
package fr.siroz.cariboustonks.manager.slayer;

import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import org.jetbrains.annotations.NotNull;

public enum SlayerType {
    ZOMBIE((class_1299<? extends class_1297>)class_1299.field_6051, "Revenant Horror", List.of("Revenant Sycophant", "Revenant Champion", "Deformed Revenant", "Atoned Champion", "Atoned Revenant"), List.of(), new int[]{5, 25, 100, 500, 1500}),
    SPIDER((class_1299<? extends class_1297>)class_1299.field_6079, "Tarantula Broodfather", List.of("Tarantula Vermin", "Tarantula Beast", "Mutant Tarantula", "Primordial Jockey", "Primordial Viscount"), List.of(class_1299.field_6137, class_1299.field_6084), new int[]{5, 25, 100, 500, 1500}),
    WOLF((class_1299<? extends class_1297>)class_1299.field_6055, "Sven Packmaster", List.of("Pack Enforcer", "Sven Follower", "Sven Alpha"), List.of(), new int[]{5, 25, 100, 500, 1500}),
    ENDERMAN((class_1299<? extends class_1297>)class_1299.field_6091, "Voidgloom Seraph", List.of("Voidling Devotee", "Voidling Radical", "Voidcrazed Maniac"), List.of(), new int[]{5, 25, 100, 500, 1500}),
    BLAZE((class_1299<? extends class_1297>)class_1299.field_6099, "Inferno Demonlord", List.of("Flare Demon", "Kindleheart Demon", "Burningsoul Demon"), List.of(), new int[]{5, 25, 100, 500, 1500}),
    VAMPIRE((class_1299<? extends class_1297>)class_1299.field_6097, "Riftstalker Bloodfiend", List.of(), List.of(), new int[]{5, 25, 100, 500, 1500}),
    UNKNOWN(null, "Unknown", List.of(), List.of(), new int[0]);

    private final class_1299<? extends class_1297> entityType;
    private final String bossName;
    private final List<String> minibossNames;
    private final List<class_1299<? extends class_1297>> minibossEntityTypes;
    private final int[] expPerTier;
    private static final Map<String, SlayerType> BOSS_NAME_TO_TYPE;

    private SlayerType(class_1299<? extends class_1297> entityType, String bossName, List<String> minibossNames, List<class_1299<? extends class_1297>> minibossEntityTypes, int[] expPerTier) {
        this.entityType = entityType;
        this.bossName = bossName;
        this.minibossNames = minibossNames;
        this.minibossEntityTypes = minibossEntityTypes;
        this.expPerTier = expPerTier;
    }

    public static SlayerType fromBossName(@NotNull String bossName) {
        return BOSS_NAME_TO_TYPE.getOrDefault(bossName.toLowerCase(), UNKNOWN);
    }

    public class_1299<? extends class_1297> getEntityType() {
        return this.entityType;
    }

    public String getBossName() {
        return this.bossName;
    }

    public List<String> getMinibossNames() {
        return this.minibossNames;
    }

    public List<class_1299<? extends class_1297>> getMinibossEntityTypes() {
        return this.minibossEntityTypes;
    }

    public int[] getExpPerTier() {
        return this.expPerTier;
    }

    static {
        BOSS_NAME_TO_TYPE = new HashMap<String, SlayerType>();
        for (SlayerType type : SlayerType.values()) {
            BOSS_NAME_TO_TYPE.put(type.getBossName().toLowerCase(Locale.ENGLISH), type);
        }
    }
}

