/*
 * Decompiled with CFR 0.152.
 */
package fr.siroz.cariboustonks.manager.waypoint.options;

import fr.siroz.cariboustonks.util.colors.Color;
import java.util.Optional;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class IconOption {
    private final class_2960 icon;
    private final float width;
    private final float height;
    private final float textureWidth;
    private final float textureHeight;
    private final class_243 renderOffset;
    private final Color color;
    private final float alpha;
    private final boolean scaleWithDistance;
    private final boolean throughBlocks;

    public IconOption() {
        this(null, 1.0f, 1.0f, 1.0f, 1.0f, new class_243(0.0, 0.0, 0.0), new Color(255, 255, 255), 1.0f, true, true);
    }

    public IconOption(@Nullable class_2960 icon, float width, float height, float textureWidth, float textureHeight, @NotNull class_243 renderOffset, @NotNull Color color, float alpha, boolean scaleWithDistance, boolean throughBlocks) {
        this.icon = icon;
        this.width = width;
        this.height = height;
        this.textureWidth = textureWidth;
        this.textureHeight = textureHeight;
        this.renderOffset = renderOffset;
        this.color = color;
        this.alpha = alpha;
        this.scaleWithDistance = scaleWithDistance;
        this.throughBlocks = throughBlocks;
    }

    @Contract(pure=true)
    @NotNull
    public Optional<class_2960> getIcon() {
        return Optional.ofNullable(this.icon);
    }

    public float getWidth() {
        return this.width;
    }

    public float getHeight() {
        return this.height;
    }

    public float getTextureWidth() {
        return this.textureWidth;
    }

    public float getTextureHeight() {
        return this.textureHeight;
    }

    public class_243 getRenderOffset() {
        return this.renderOffset;
    }

    public Color getColor() {
        return this.color;
    }

    public float getAlpha() {
        return this.alpha;
    }

    public boolean isScaleWithDistance() {
        return this.scaleWithDistance;
    }

    public boolean isThroughBlocks() {
        return this.throughBlocks;
    }

    @Contract(value=" -> new", pure=true)
    @NotNull
    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        protected class_2960 icon = null;
        protected float width = 1.0f;
        protected float height = 1.0f;
        protected float textureWidth = 1.0f;
        protected float textureHeight = 1.0f;
        protected class_243 renderOffset = new class_243(0.0, 0.0, 0.0);
        protected Color color = new Color(255, 255, 255);
        protected float alpha = 1.0f;
        protected boolean scaleWithDistance = true;
        protected boolean throughBlocks = true;

        public Builder withIcon(@Nullable class_2960 icon) {
            this.icon = icon;
            return this;
        }

        public Builder withWidth(float width) {
            this.width = width;
            return this;
        }

        public Builder withHeight(float height) {
            this.height = height;
            return this;
        }

        public Builder withTextureWidth(float textureWidth) {
            this.textureWidth = textureWidth;
            return this;
        }

        public Builder withTextureHeight(float textureHeight) {
            this.textureHeight = textureHeight;
            return this;
        }

        public Builder withRenderOffset(@NotNull class_243 renderOffset) {
            this.renderOffset = renderOffset;
            return this;
        }

        public Builder withColor(@NotNull Color color) {
            this.color = color;
            return this;
        }

        public Builder withAlpha(float alpha) {
            this.alpha = alpha;
            return this;
        }

        public Builder withScaleWithDistance(boolean scaleWithDistance) {
            this.scaleWithDistance = scaleWithDistance;
            return this;
        }

        public Builder withThroughBlocks(boolean throughBlocks) {
            this.throughBlocks = throughBlocks;
            return this;
        }

        public IconOption build() {
            return new IconOption(this.icon, this.width, this.height, this.textureWidth, this.textureHeight, this.renderOffset, this.color, this.alpha, this.scaleWithDistance, this.throughBlocks);
        }
    }
}

