/*
 * Decompiled with CFR 0.152.
 */
package fr.siroz.cariboustonks.screen;

import fr.siroz.cariboustonks.CaribouStonks;
import fr.siroz.cariboustonks.config.ConfigManager;
import fr.siroz.cariboustonks.manager.hud.Hud;
import fr.siroz.cariboustonks.manager.hud.HudManager;
import fr.siroz.cariboustonks.screen.CaribousStonksScreen;
import fr.siroz.cariboustonks.util.colors.Colors;
import fr.siroz.cariboustonks.util.render.GuiRenderUtils;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_437;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class HudConfigScreen
extends CaribousStonksScreen {
    private final List<Hud> hudList = CaribouStonks.managers().getManager(HudManager.class).getHudList();
    @Nullable
    private final class_437 parent;
    @Nullable
    private Hud selected = null;

    private HudConfigScreen(@Nullable class_437 parent) {
        super(class_2561.method_30163((String)"HUD Config Screen"));
        this.parent = parent;
    }

    @Contract(value="_ -> new")
    @NotNull
    public static HudConfigScreen create(@Nullable class_437 parent) {
        return new HudConfigScreen(parent);
    }

    @Override
    public void onRender(class_332 context, int mouseX, int mouseY, float delta) {
        super.onRender(context, mouseX, mouseY, delta);
        this.renderInformations(context);
        this.renderElements(context);
    }

    private void renderInformations(@NotNull class_332 context) {
        Objects.requireNonNull(this.field_22793);
        int baseY = 9 * 8;
        Objects.requireNonNull(this.field_22793);
        int lineSpacing = 9 + 4;
        int y = baseY;
        context.method_25300(this.field_22793, "LEFT-CLICK to select an HUD", this.field_22789 >> 1, y, Colors.LIGHT_GRAY.asInt());
        context.method_25300(this.field_22793, "RIGHT-CLICK to unselect an HUD", this.field_22789 >> 1, y += lineSpacing, Colors.LIGHT_GRAY.asInt());
        context.method_25300(this.field_22793, "Press +/- to scale an HUD", this.field_22789 >> 1, y += lineSpacing, Colors.LIGHT_GRAY.asInt());
        context.method_25300(this.field_22793, "Press R to reset an HUD's position & scale", this.field_22789 >> 1, y += lineSpacing, Colors.LIGHT_GRAY.asInt());
        context.method_25300(this.field_22793, "Press TAB to cycle between HUDs", this.field_22789 >> 1, y += lineSpacing, Colors.LIGHT_GRAY.asInt());
    }

    private void renderElements(@NotNull class_332 context) {
        for (Hud hud : this.hudList) {
            hud.renderScreen(context);
        }
        if (this.selected != null) {
            int x = this.selected.x();
            int y = this.selected.y();
            int width = this.selected.width();
            int height = this.selected.height();
            int marginTop = 2;
            int marginLeft = 2;
            int bX = Math.max(x - marginLeft, 0);
            int bY = Math.max(y - marginTop, 0);
            int bWidth = Math.min(x + width + 2, this.field_22789) - bX;
            int bHeight = Math.min(y + height + 2, this.field_22790) - bY;
            context.method_49601(bX, bY, bWidth, bHeight, Colors.RED.asInt());
        }
    }

    @Override
    public boolean onMouseClicked(double mouseX, double mouseY, int button) {
        switch (button) {
            case 0: {
                for (Hud element : this.hudList) {
                    if (!GuiRenderUtils.pointIsInArea(mouseX, mouseY, element.x(), element.y(), element.x() + element.width(), element.y() + element.height()) || this.selected == element) continue;
                    this.selected = element;
                    return true;
                }
                break;
            }
            case 1: {
                this.selected = null;
                return true;
            }
        }
        return super.onMouseClicked(mouseX, mouseY, button);
    }

    public boolean method_25403(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        if (this.selected != null && button == 0) {
            this.selected.setX((int)Math.clamp(mouseX - (double)(this.selected.width() >> 1), 0.0, (double)(this.field_22789 - this.selected.width())));
            this.selected.setY((int)Math.clamp(mouseY - (double)(this.selected.height() >> 1), 0.0, (double)(this.field_22790 - this.selected.height())));
        }
        return super.method_25403(mouseX, mouseY, button, deltaX, deltaY);
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        switch (keyCode) {
            case 61: 
            case 334: {
                if (this.selected == null || keyCode == 61 && (modifiers & 1) == 0) break;
                this.selected.setScale(this.selected.scale() + 0.1f);
                return true;
            }
            case 45: 
            case 333: {
                if (this.selected == null || keyCode == 45 && (modifiers & 1) == 0) break;
                this.selected.setScale(this.selected.scale() - 0.1f);
                return true;
            }
            case 82: {
                if (this.selected == null) break;
                this.selected.reset();
                return true;
            }
            case 258: {
                if (this.hudList.isEmpty()) break;
                if (this.selected == null) {
                    this.selected = this.hudList.getFirst();
                } else {
                    int index = this.hudList.indexOf(this.selected);
                    int nextIndex = (index + 1) % this.hudList.size();
                    this.selected = this.hudList.get(nextIndex);
                }
                return true;
            }
        }
        return super.method_25404(keyCode, scanCode, modifiers);
    }

    @Override
    public void onClose() {
        boolean changed = false;
        for (Hud hud : this.hudList) {
            if (!hud.apply()) continue;
            changed = true;
        }
        if (changed) {
            ConfigManager.saveConfig();
        }
        assert (this.field_22787 != null);
        this.field_22787.method_1507(this.parent);
    }
}

