/*
 * Decompiled with CFR 0.152.
 */
package fr.siroz.cariboustonks.util;

import com.google.gson.JsonElement;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import fr.siroz.cariboustonks.CaribouStonks;
import fr.siroz.cariboustonks.core.json.GsonProvider;
import fr.siroz.cariboustonks.core.scheduler.TickScheduler;
import fr.siroz.cariboustonks.event.NetworkEvents;
import fr.siroz.cariboustonks.event.WorldEvents;
import fr.siroz.cariboustonks.util.Client;
import fr.siroz.cariboustonks.util.InventoryUtils;
import fr.siroz.cariboustonks.util.ItemUtils;
import fr.siroz.cariboustonks.util.TimeUtils;
import fr.siroz.cariboustonks.util.colors.Color;
import fr.siroz.cariboustonks.util.colors.Colors;
import fr.siroz.cariboustonks.util.render.Texture;
import fr.siroz.cariboustonks.util.render.WorldRenderUtils;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.Instant;
import java.util.List;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandManager;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandRegistrationCallback;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayConnectionEvents;
import net.fabricmc.fabric.api.client.rendering.v1.WorldRenderContext;
import net.fabricmc.fabric.api.client.rendering.v1.WorldRenderEvents;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_124;
import net.minecraft.class_1301;
import net.minecraft.class_1309;
import net.minecraft.class_1531;
import net.minecraft.class_155;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2767;
import net.minecraft.class_310;
import net.minecraft.class_3414;
import net.minecraft.class_5250;
import net.minecraft.class_6489;
import net.minecraft.class_7225;
import net.minecraft.class_7887;
import net.minecraft.class_9322;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public final class DeveloperTools {
    private static final boolean SYSTEM_DEBUG = Boolean.parseBoolean(System.getProperty("stonks.debug", "false"));
    private static final Object2IntOpenHashMap<class_1531> ARMORSTANDS_TEXTURED = new Object2IntOpenHashMap();
    private static final class_7225.class_7874 LOOKUP = class_7887.method_46817();
    private static boolean dumpSound = false;

    private DeveloperTools() {
    }

    public static void initDeveloperTools() {
        ClientCommandRegistrationCallback.EVENT.register((dispatcher, _ra) -> dispatcher.register((LiteralArgumentBuilder)ClientCommandManager.literal((String)"cariboustonks").then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)ClientCommandManager.literal((String)"devtools").then(DeveloperTools.dumpSoundCommand())).then(DeveloperTools.dumpHeldItemSimpleCommand())).then(DeveloperTools.dumpHeldItemCommand())).then(DeveloperTools.dumpArmorStandHeadTextures()))));
        WorldRenderEvents.AFTER_TRANSLUCENT.register(DeveloperTools::render);
        if (DeveloperTools.isInDevelopment()) {
            class_6489 version = class_155.method_16673();
            CaribouStonks.LOGGER.warn("Debug mode enabled ({}) {}", (Object)version.method_48019(), (Object)(DeveloperTools.isSnapshot() ? "(Snapshot)" : ""));
            ClientPlayConnectionEvents.JOIN.register((handler, sender, client) -> {
                if (client.field_1724 != null && DeveloperTools.isInDevelopment()) {
                    class_5250 snapShot = DeveloperTools.isSnapshot() ? class_2561.method_43470((String)" (Snapshot)").method_27692(class_124.field_1079) : class_2561.method_43473();
                    client.field_1724.method_7353((class_2561)CaribouStonks.prefix().get().method_10852((class_2561)class_2561.method_43470((String)("Debug mode enabled (" + version.method_48019() + ")")).method_27692(class_124.field_1061).method_10852((class_2561)snapShot)), false);
                }
            });
            WorldRenderEvents.AFTER_TRANSLUCENT.register(DeveloperTools::debugRender);
            WorldEvents.ALLOW_SOUND.register(DeveloperTools::onSound);
            NetworkEvents.PLAY_SOUND_PACKET.register(DeveloperTools::onSoundPacket);
        }
    }

    public static boolean isInDevelopment() {
        return FabricLoader.getInstance().isDevelopmentEnvironment() || !class_155.method_16673().method_48022() || SYSTEM_DEBUG;
    }

    public static boolean isSnapshot() {
        return !class_155.method_16673().method_48022();
    }

    public static class_7225.class_7874 getRegistryLookup() {
        class_310 client = class_310.method_1551();
        return client != null && client.method_1562() != null && client.method_1562().method_29091() != null ? client.method_1562().method_29091() : LOOKUP;
    }

    private static void render(WorldRenderContext context) {
        if (!ARMORSTANDS_TEXTURED.isEmpty()) {
            for (Object2IntMap.Entry armorStand : ARMORSTANDS_TEXTURED.object2IntEntrySet()) {
                class_1531 entity = (class_1531)armorStand.getKey();
                if (entity == null || entity.method_19538() == null) continue;
                class_243 centerPos = entity.method_19538();
                WorldRenderUtils.renderText(context, (class_2561)class_2561.method_43470((String)("#" + armorStand.getIntValue())), centerPos.method_1031(0.0, 1.0, 0.0), 1.0f, true);
            }
        }
    }

    private static void debugRender(WorldRenderContext context) {
        WorldRenderUtils.renderText(context, class_2561.method_30163((String)("CaribouStonks " + class_155.method_16673().method_48019())), new class_243(-1.5, 69.0, 25.5), 1.3f, true);
        WorldRenderUtils.renderFilledWithBeaconBeam(context, new class_2338(1, 70, 25), Colors.RED, 0.5f, true);
        WorldRenderUtils.renderCircle(context, new class_243(5.0, 65.0, 18.0), 5.0, 16, 0.02f, Colors.YELLOW, class_2350.class_2351.field_11052, false);
        WorldRenderUtils.renderThickCircle(context, new class_243(5.0, 63.0, 24.0), 5.0, 2.0, 64, Colors.AQUA.withAlpha(0.5f), false);
        WorldRenderUtils.renderLinesFromPoints(context, new class_243[]{new class_243(0.0, 68.0, 17.0), new class_243(4.0, 70.0, 20.0), new class_243(5.0, 71.0, 17.0)}, Colors.MAGENTA, 5.0f, true);
        WorldRenderUtils.renderQuad(context, new class_243[]{new class_243(4.0, 66.0, 29.5), new class_243(4.0, 66.0, 28.5), new class_243(4.0, 68.0, 28.5), new class_243(4.0, 68.0, 29.5)}, Colors.YELLOW, 0.5f, true);
        class_243 centerPos = new class_243(3.0, 66.0, 18.0);
        double distance = context.camera().method_19326().method_1022(centerPos);
        float scale = Math.max((float)distance / 10.0f, 1.0f);
        WorldRenderUtils.renderTexture(context, centerPos, scale, scale, 1.0f, 1.0f, new class_243(0.0, 0.0, 0.0), Texture.NETHERITE_SWORD, new Color(255, 255, 255), 1.0f, true);
    }

    private static boolean onSound(@NotNull class_3414 soundEvent) {
        if (dumpSound) {
            String soundId = soundEvent.comp_3319().method_12832();
            String time = TimeUtils.formatInstant(Instant.now(), TimeUtils.TIME_HH_MM_SS);
            Client.sendMessage((class_2561)class_2561.method_43470((String)("(Client) " + time + " :: " + soundId)));
        }
        return true;
    }

    private static void onSoundPacket(class_2767 packet) {
        if (dumpSound) {
            String soundId = ((class_3414)packet.method_11894().comp_349()).comp_3319().method_12832();
            String time = TimeUtils.formatInstant(Instant.now(), TimeUtils.TIME_HH_MM_SS);
            String pitch = BigDecimal.valueOf(packet.method_11892()).setScale(3, RoundingMode.DOWN).stripTrailingZeros().toPlainString();
            String volume = BigDecimal.valueOf(packet.method_11891()).setScale(3, RoundingMode.DOWN).stripTrailingZeros().toPlainString();
            Client.sendMessage((class_2561)class_2561.method_43470((String)("(Server) " + time + " :: " + soundId + " Pitch: " + pitch + " Volume: " + volume)));
        }
    }

    private static LiteralArgumentBuilder<FabricClientCommandSource> dumpHeldItemSimpleCommand() {
        return (LiteralArgumentBuilder)ClientCommandManager.literal((String)"dumpHeldItemSimple").executes(context -> {
            class_1799 item = ((FabricClientCommandSource)context.getSource()).getPlayer().method_6047();
            if (item == null || item.method_7960()) {
                ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)CaribouStonks.prefix().get().method_10852((class_2561)class_2561.method_43470((String)"Item is null or empty").method_27692(class_124.field_1061)));
            } else {
                class_5250 message = class_2561.method_43473();
                message.method_10852(item.method_7964()).method_27693(" :").method_27693("\n").method_27693(" - SkyBlockItemId: " + ItemUtils.getSkyBlockItemId((class_9322)item)).method_27692(class_124.field_1080).method_27693("\n").method_27693(" - SkyBlockApiId: " + ItemUtils.getSkyBlockApiId((class_9322)item)).method_27692(class_124.field_1080);
                ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)CaribouStonks.prefix().get().method_10852((class_2561)message));
            }
            return 1;
        });
    }

    private static LiteralArgumentBuilder<FabricClientCommandSource> dumpHeldItemCommand() {
        return (LiteralArgumentBuilder)ClientCommandManager.literal((String)"dumpHeldItem").executes(context -> {
            String json = GsonProvider.standard().toJson((JsonElement)class_1799.field_24671.encodeStart((DynamicOps)DeveloperTools.getRegistryLookup().method_57093((DynamicOps)JsonOps.INSTANCE), (Object)((FabricClientCommandSource)context.getSource()).getPlayer().method_6047()).getOrThrow());
            ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)CaribouStonks.prefix().get().method_10852((class_2561)class_2561.method_43470((String)("Debug Held Item: " + json))));
            return 1;
        });
    }

    private static LiteralArgumentBuilder<FabricClientCommandSource> dumpArmorStandHeadTextures() {
        return (LiteralArgumentBuilder)ClientCommandManager.literal((String)"dumpArmorStandHeadTextures").executes(context -> {
            ARMORSTANDS_TEXTURED.clear();
            TickScheduler.getInstance().runLater(() -> ARMORSTANDS_TEXTURED.clear(), 200);
            List armorStands = ((FabricClientCommandSource)context.getSource()).getWorld().method_8390(class_1531.class, ((FabricClientCommandSource)context.getSource()).getPlayer().method_5829().method_1014(8.0), class_1301.field_6153);
            int id = 0;
            for (class_1531 armorStand : armorStands) {
                ARMORSTANDS_TEXTURED.put((Object)armorStand, id);
                List<class_1799> equippedItems = InventoryUtils.getArmorFromEntity((class_1309)armorStand);
                ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)CaribouStonks.prefix().get().method_10852((class_2561)class_2561.method_43470((String)("Head texture #" + id + ": "))));
                for (class_1799 stack : equippedItems) {
                    ItemUtils.getHeadTextureOptional(stack).ifPresent(texture -> ((FabricClientCommandSource)context.getSource()).sendFeedback(class_2561.method_30163((String)texture)));
                }
                ++id;
            }
            return 1;
        });
    }

    private static LiteralArgumentBuilder<FabricClientCommandSource> dumpSoundCommand() {
        return (LiteralArgumentBuilder)ClientCommandManager.literal((String)"dumpSound").executes(context -> {
            dumpSound = !dumpSound;
            ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)CaribouStonks.prefix().get().method_10852((class_2561)class_2561.method_43470((String)("Dump sound: " + dumpSound))));
            return 1;
        });
    }
}

