/*
 * Decompiled with CFR 0.152.
 */
package fr.siroz.cariboustonks.util.math.bezier;

import fr.siroz.cariboustonks.util.math.bezier.Matrix;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.IntStream;

public class PolynomialFitter {
    private final int degree;
    private final List<double[]> xValues = new ArrayList<double[]>();
    private final List<double[]> yValues = new ArrayList<double[]>();

    public PolynomialFitter(int degree) {
        this.degree = degree;
    }

    public void addPoint(double x, double y) {
        this.yValues.add(new double[]{y});
        double[] xArray = IntStream.range(0, this.degree + 1).mapToDouble(i -> Math.pow(x, i)).toArray();
        this.xValues.add(xArray);
    }

    public double[] fit() {
        Matrix xMatrix = new Matrix((double[][])this.xValues.toArray((T[])new double[0][0]));
        Matrix yMatrix = new Matrix((double[][])this.yValues.toArray((T[])new double[0][0]));
        Matrix xMatrixTransposed = xMatrix.transpose();
        return xMatrixTransposed.multiply(xMatrix).inverse().multiply(xMatrixTransposed).multiply(yMatrix).transpose().getRow(0);
    }

    public void reset() {
        this.xValues.clear();
        this.yValues.clear();
    }
}

