/*
 * Decompiled with CFR 0.152.
 */
package fr.siroz.cariboustonks.util.render.gui;

import fr.siroz.cariboustonks.util.colors.Color;
import fr.siroz.cariboustonks.util.colors.Colors;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public record ColorHighlight(int slot, Color color) {
    private static final Color RED = Colors.RED;
    private static final Color YELLOW = Colors.YELLOW;
    private static final Color GREEN = Colors.GREEN;

    @Contract(value="_ -> new")
    @NotNull
    public static ColorHighlight red(int slot) {
        return new ColorHighlight(slot, RED);
    }

    @Contract(value="_, _ -> new")
    @NotNull
    public static ColorHighlight red(int slot, float alpha) {
        return new ColorHighlight(slot, RED.withAlpha(alpha));
    }

    @Contract(value="_ -> new")
    @NotNull
    public static ColorHighlight yellow(int slot) {
        return new ColorHighlight(slot, YELLOW);
    }

    @Contract(value="_, _ -> new")
    @NotNull
    public static ColorHighlight yellow(int slot, float alpha) {
        return new ColorHighlight(slot, YELLOW.withAlpha(alpha));
    }

    @Contract(value="_ -> new")
    @NotNull
    public static ColorHighlight green(int slot) {
        return new ColorHighlight(slot, GREEN);
    }

    @Contract(value="_, _ -> new")
    @NotNull
    public static ColorHighlight green(int slot, float alpha) {
        return new ColorHighlight(slot, GREEN.withAlpha(alpha));
    }
}

