/*
 * Decompiled with CFR 0.152.
 */
package fr.siroz.cariboustonks.core;

import fr.siroz.cariboustonks.CaribouStonks;
import fr.siroz.cariboustonks.core.HypixelModAPI;
import fr.siroz.cariboustonks.core.WelcomeMessage;
import fr.siroz.cariboustonks.core.crash.CrashType;
import fr.siroz.cariboustonks.core.data.generic.GenericDataSource;
import fr.siroz.cariboustonks.core.data.hypixel.HypixelDataSource;
import fr.siroz.cariboustonks.core.data.mod.ModDataSource;
import fr.siroz.cariboustonks.core.json.JsonFileService;
import fr.siroz.cariboustonks.core.scheduler.TickScheduler;
import fr.siroz.cariboustonks.core.skyblock.IslandType;
import fr.siroz.cariboustonks.core.skyblock.SkyBlockAPI;
import fr.siroz.cariboustonks.event.SkyBlockEvents;
import fr.siroz.cariboustonks.util.Client;
import java.util.Locale;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayConnectionEvents;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

public final class CaribouStonksCore {
    private static final Set<String> REPORTED_CRASHES = ConcurrentHashMap.newKeySet();
    private final JsonFileService jsonFileService;
    private final ModDataSource modDataSource;
    private final HypixelDataSource hypixelDataSource;
    private final GenericDataSource genericDataSource;

    @ApiStatus.Internal
    public CaribouStonksCore() {
        CaribouStonks.LOGGER.info("[CaribouStonksCore] Loading..");
        TickScheduler.getInstance().runRepeating(SkyBlockAPI::update, 3, TimeUnit.SECONDS);
        ClientPlayConnectionEvents.DISCONNECT.register((_handler, _client) -> this.onDisconnect());
        this.jsonFileService = new JsonFileService();
        this.modDataSource = new ModDataSource();
        this.hypixelDataSource = new HypixelDataSource(this.modDataSource);
        this.genericDataSource = new GenericDataSource();
        new HypixelModAPI();
        new WelcomeMessage();
        CaribouStonks.LOGGER.info("[CaribouStonksCore] Loaded!");
    }

    public JsonFileService getJsonFileService() {
        return this.jsonFileService;
    }

    public ModDataSource getModDataSource() {
        return this.modDataSource;
    }

    public HypixelDataSource getHypixelDataSource() {
        return this.hypixelDataSource;
    }

    public GenericDataSource getGenericDataSource() {
        return this.genericDataSource;
    }

    public void reportCrash(@NotNull CrashType type, @NotNull String niceName, @NotNull String fullName, @NotNull String reason, Throwable throwable) {
        this.reportCrash(type, niceName, fullName, reason, true, true, throwable);
    }

    public void reportCrash(@NotNull CrashType type, @NotNull String niceName, @NotNull String fullName, @NotNull String reason, boolean shouldSendChat, boolean shouldSendNotification, Throwable throwable) {
        String crashSignature = fullName + "|" + reason;
        if (shouldSendChat && !REPORTED_CRASHES.contains(crashSignature)) {
            Client.sendErrorMessage("CaribouStonks error: " + type.getName() + " '" + niceName + "' was crashed in " + reason, shouldSendNotification);
        }
        REPORTED_CRASHES.add(crashSignature);
        CaribouStonks.LOGGER.warn("---------------- STONKS CRASH ----------------");
        CaribouStonks.LOGGER.warn("CrashType of {} {} due to {}", new Object[]{type.toString().toLowerCase(Locale.ROOT), niceName, reason});
        CaribouStonks.LOGGER.error("Exception thrown by {}", (Object)fullName, (Object)throwable);
        CaribouStonks.LOGGER.warn("----------------------------------------------");
    }

    private void onDisconnect() {
        if (SkyBlockAPI.isOnSkyBlock()) {
            ((SkyBlockEvents.Leave)SkyBlockEvents.LEAVE.invoker()).onLeave();
        }
        SkyBlockAPI.handleLocationUpdate(null, false, "", IslandType.UNKNOWN);
    }
}

