/*
 * Decompiled with CFR 0.152.
 */
package fr.siroz.cariboustonks.core.data.algo;

import fr.siroz.cariboustonks.core.data.hypixel.bazaar.Product;
import fr.siroz.cariboustonks.core.data.hypixel.bazaar.Summary;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Range;

public interface BazaarItemAnalytics {
    public static double buyPrice(@NotNull Product product) {
        List<Summary> summaries = product.buySummary();
        if (summaries.isEmpty()) {
            return -1.0;
        }
        return summaries.stream().map(Summary::pricePerUnit).min(Double::compareTo).orElse(0.0);
    }

    public static double sellPrice(@NotNull Product product) {
        List<Summary> summaries = product.sellSummary();
        if (summaries.isEmpty()) {
            return -1.0;
        }
        return summaries.stream().map(Summary::pricePerUnit).max(Double::compareTo).orElse(0.0);
    }

    public static double weightedAverageBuyPrice(@NotNull Product product) {
        return product.quickStatus().buyPrice();
    }

    public static double weightedAverageSellPrice(@NotNull Product product) {
        return product.quickStatus().sellPrice();
    }

    public static double spreadPercentage(@NotNull Product product) {
        List<Summary> sellSummaries = product.sellSummary();
        List<Summary> buySummaries = product.buySummary();
        if (sellSummaries.isEmpty() || buySummaries.isEmpty()) {
            return -1.0;
        }
        double bestBuy = sellSummaries.stream().map(Summary::pricePerUnit).max(Double::compareTo).orElse(Double.NaN);
        double bestSell = buySummaries.stream().map(Summary::pricePerUnit).min(Double::compareTo).orElse(Double.NaN);
        if (Double.isNaN(bestBuy) || Double.isNaN(bestSell) || bestSell == 0.0) {
            return -1.0;
        }
        return (bestBuy - bestSell) / bestSell * 100.0;
    }

    public static double orderImbalancePercentage(@NotNull Product product) {
        long numberOfBuyers;
        long numberOfSellers = product.quickStatus().buyOrders();
        long totalOrders = numberOfSellers + (numberOfBuyers = product.quickStatus().sellOrders());
        if (totalOrders == 0L) {
            return 0.0;
        }
        return (double)(numberOfSellers - numberOfBuyers) / (double)totalOrders * 100.0;
    }

    public static double vwap(@NotNull Product product) {
        List<Summary> summaries = product.buySummary();
        if (summaries.isEmpty()) {
            return -1.0;
        }
        double totalValue = summaries.stream().mapToDouble(s -> s.pricePerUnit() * (double)s.amount()).sum();
        long totalVolume = summaries.stream().mapToLong(Summary::amount).sum();
        if (totalVolume == 0L) {
            return -1.0;
        }
        return totalValue / (double)totalVolume;
    }

    public static double standardDeviation(@NotNull List<Summary> summaries) {
        int count = summaries.size();
        if (count == 0) {
            return -1.0;
        }
        double sum = 0.0;
        double squareSum = 0.0;
        int validCount = 0;
        for (Summary s : summaries) {
            double price = s.pricePerUnit();
            if (!Double.isFinite(price) || !(price > 0.0)) continue;
            sum += price;
            squareSum += price * price;
            ++validCount;
        }
        if (validCount == 0) {
            return -1.0;
        }
        double mean = sum / (double)validCount;
        double variance = squareSum / (double)validCount - mean * mean;
        return variance > 0.0 ? Math.sqrt(variance) : 0.0;
    }

    public static double calculateSellSideLiquiditySlope(@NotNull Product product, @Range(from=1L, to=100L) double volumeTargetPercentage) {
        double startPrice;
        List<Summary> sellOrders = product.buySummary();
        if (sellOrders.isEmpty() || volumeTargetPercentage <= 0.0 || volumeTargetPercentage > 100.0) {
            return -1.0;
        }
        ArrayList<Summary> sorted = new ArrayList<Summary>(sellOrders);
        sorted.sort(Comparator.comparingDouble(Summary::pricePerUnit));
        double totalVolume = sorted.stream().mapToDouble(Summary::amount).sum();
        double targetVolume = totalVolume * (volumeTargetPercentage / 100.0);
        if (targetVolume <= 0.0) {
            return -1.0;
        }
        double cumulativeVolume = 0.0;
        double targetPrice = startPrice = ((Summary)sorted.getFirst()).pricePerUnit();
        for (Summary s : sorted) {
            double orderVolume = s.amount();
            if (cumulativeVolume + orderVolume >= targetVolume) {
                double remainingVolume = targetVolume - cumulativeVolume;
                targetPrice = (cumulativeVolume * targetPrice + remainingVolume * s.pricePerUnit()) / targetVolume;
                break;
            }
            cumulativeVolume += orderVolume;
            targetPrice = s.pricePerUnit();
        }
        return (targetPrice - startPrice) / targetVolume;
    }
}

