/*
 * Decompiled with CFR 0.152.
 */
package fr.siroz.cariboustonks.core.data.mod;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import fr.siroz.cariboustonks.CaribouStonks;
import fr.siroz.cariboustonks.core.data.mod.SkyBlockAttribute;
import fr.siroz.cariboustonks.core.data.mod.SkyBlockEnchantment;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectList;
import java.io.BufferedReader;
import java.io.Reader;
import java.util.Map;
import java.util.OptionalInt;
import java.util.concurrent.CompletableFuture;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientLifecycleEvents;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ModDataSource {
    private static final class_2960 ITEMS_MAPPING_JSON = CaribouStonks.identifier("repo/items_mapping.json");
    private final Object2ObjectMap<String, String> minecraftIdsMapping = new Object2ObjectOpenHashMap();
    private static final class_2960 ENCHANTMENTS_JSON = CaribouStonks.identifier("repo/enchantments.json");
    private final Object2ObjectMap<String, SkyBlockEnchantment> skyBlockEnchants = new Object2ObjectOpenHashMap();
    private static final class_2960 ATTRIBUTES_JSON = CaribouStonks.identifier("repo/attributes.json");
    private final ObjectList<SkyBlockAttribute> skyBlockAttributes = new ObjectArrayList();
    private boolean itemsMappingError = false;
    private boolean enchantmentsError = false;
    private boolean attributesError = false;

    @ApiStatus.Internal
    public ModDataSource() {
        ClientLifecycleEvents.CLIENT_STARTED.register(client -> this.loadModData(client).thenRun(this::checkResults));
    }

    @Nullable
    public String getMinecraftId(@NotNull String hypixelMaterial) {
        if (this.minecraftIdsMapping.isEmpty()) {
            return null;
        }
        return (String)this.minecraftIdsMapping.get((Object)hypixelMaterial);
    }

    public boolean containsItem(@NotNull String hypixelMaterial) {
        if (this.minecraftIdsMapping.isEmpty()) {
            return false;
        }
        return this.minecraftIdsMapping.containsKey((Object)hypixelMaterial);
    }

    public boolean isItemsMappingError() {
        return this.itemsMappingError;
    }

    @Nullable
    public SkyBlockEnchantment getSkyBlockEnchantment(@NotNull String id) {
        if (this.skyBlockEnchants.isEmpty()) {
            return null;
        }
        return (SkyBlockEnchantment)this.skyBlockEnchants.get((Object)id);
    }

    public boolean containsEnchantment(@NotNull String enchantmentId) {
        if (this.skyBlockEnchants.isEmpty()) {
            return false;
        }
        return this.skyBlockEnchants.containsKey((Object)enchantmentId);
    }

    public boolean isEnchantmentsError() {
        return this.enchantmentsError;
    }

    @Nullable
    public SkyBlockAttribute getAttributeById(@Nullable String id) {
        if (id == null || id.isEmpty() || this.skyBlockAttributes.isEmpty()) {
            return null;
        }
        for (SkyBlockAttribute attribute : this.skyBlockAttributes) {
            if (!attribute.id().equals(id)) continue;
            return attribute;
        }
        return null;
    }

    @Nullable
    public SkyBlockAttribute getAttributeByShardName(@Nullable String name) {
        if (name == null || name.isEmpty() || this.skyBlockAttributes.isEmpty()) {
            return null;
        }
        for (SkyBlockAttribute attribute : this.skyBlockAttributes) {
            if (!attribute.shardName().equals(name)) continue;
            return attribute;
        }
        return null;
    }

    @NotNull
    private CompletableFuture<Void> loadModData(class_310 client) {
        CompletableFuture<Void> itemsMappingFuture = CompletableFuture.runAsync(() -> {
            try (BufferedReader reader = client.method_1478().openAsReader(ITEMS_MAPPING_JSON);){
                JsonObject jsonMapping = JsonParser.parseReader((Reader)reader).getAsJsonObject();
                for (Map.Entry entry : jsonMapping.entrySet()) {
                    this.minecraftIdsMapping.put((Object)((String)entry.getKey()), (Object)((JsonElement)entry.getValue()).getAsString());
                }
            }
            catch (Exception ex) {
                this.itemsMappingError = true;
                CaribouStonks.LOGGER.error("[ModDataSource] There was an error while loading items mapping", (Throwable)ex);
            }
        });
        CompletableFuture<Void> enchantmentsFuture = CompletableFuture.runAsync(() -> {
            try (BufferedReader reader = client.method_1478().openAsReader(ENCHANTMENTS_JSON);){
                JsonArray jsonArray = JsonParser.parseReader((Reader)reader).getAsJsonArray();
                for (JsonElement element : jsonArray) {
                    JsonObject jsonEnchantment = element.getAsJsonObject();
                    SkyBlockEnchantment enchantment = this.getSkyBlockEnchantment(jsonEnchantment);
                    this.skyBlockEnchants.put((Object)enchantment.id(), (Object)enchantment);
                }
            }
            catch (Throwable throwable) {
                this.enchantmentsError = true;
                CaribouStonks.LOGGER.error("[ModDataSource] There was an error while loading enchantments", throwable);
            }
        });
        CompletableFuture<Void> attributesFuture = CompletableFuture.runAsync(() -> {
            try (BufferedReader reader = client.method_1478().openAsReader(ATTRIBUTES_JSON);){
                JsonArray jsonArray = JsonParser.parseReader((Reader)reader).getAsJsonArray();
                for (JsonElement element : jsonArray) {
                    JsonObject jsonAttribute = element.getAsJsonObject();
                    SkyBlockAttribute attribute = this.getSkyBlockAttribute(jsonAttribute);
                    this.skyBlockAttributes.add((Object)attribute);
                }
            }
            catch (Throwable throwable) {
                this.attributesError = true;
                CaribouStonks.LOGGER.error("[ModDataSource] There was an error while loading attributes", throwable);
            }
        });
        return CompletableFuture.allOf(itemsMappingFuture, enchantmentsFuture, attributesFuture);
    }

    private void checkResults() {
        if (!this.itemsMappingError && !this.minecraftIdsMapping.isEmpty()) {
            CaribouStonks.LOGGER.info("[ModDataSource] Loaded {} items in the items mapping", (Object)this.minecraftIdsMapping.size());
        }
        if (!this.enchantmentsError && !this.skyBlockEnchants.isEmpty()) {
            CaribouStonks.LOGGER.info("[ModDataSource] Loaded {} enchantments", (Object)this.skyBlockEnchants.size());
        }
        if (!this.attributesError && !this.skyBlockAttributes.isEmpty()) {
            CaribouStonks.LOGGER.info("[ModDataSource] Loaded {} attributes", (Object)this.skyBlockAttributes.size());
        }
    }

    @Contract(value="_ -> new")
    @NotNull
    private SkyBlockEnchantment getSkyBlockEnchantment(@NotNull JsonObject jsonEnchantment) {
        return new SkyBlockEnchantment(jsonEnchantment.get("id").getAsString(), jsonEnchantment.get("name").getAsString(), jsonEnchantment.get("maxLevel").getAsInt(), jsonEnchantment.has("goodLevel") ? OptionalInt.of(jsonEnchantment.get("goodLevel").getAsInt()) : OptionalInt.empty());
    }

    @Contract(value="_ -> new")
    @NotNull
    private SkyBlockAttribute getSkyBlockAttribute(@NotNull JsonObject jsonAttribute) {
        return new SkyBlockAttribute(jsonAttribute.get("name").getAsString(), jsonAttribute.get("shardName").getAsString(), jsonAttribute.get("id").getAsString(), jsonAttribute.get("skyBlockApiId").getAsString());
    }
}

