/*
 * Decompiled with CFR 0.152.
 */
package fr.siroz.cariboustonks.feature.fishing;

import fr.siroz.cariboustonks.CaribouStonks;
import fr.siroz.cariboustonks.config.ConfigManager;
import fr.siroz.cariboustonks.core.scheduler.TickScheduler;
import fr.siroz.cariboustonks.core.skyblock.IslandType;
import fr.siroz.cariboustonks.core.skyblock.SkyBlockAPI;
import fr.siroz.cariboustonks.event.NetworkEvents;
import fr.siroz.cariboustonks.event.WorldEvents;
import fr.siroz.cariboustonks.feature.Feature;
import fr.siroz.cariboustonks.feature.fishing.Hotspot;
import fr.siroz.cariboustonks.feature.fishing.HotspotRenderer;
import fr.siroz.cariboustonks.feature.fishing.radar.HotspotRadarFeature;
import fr.siroz.cariboustonks.util.PositionUtils;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import net.fabricmc.fabric.api.client.rendering.v1.WorldRenderContext;
import net.fabricmc.fabric.api.client.rendering.v1.WorldRenderEvents;
import net.minecraft.class_1297;
import net.minecraft.class_1531;
import net.minecraft.class_1536;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2374;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2675;
import net.minecraft.class_310;
import org.jetbrains.annotations.Nullable;

public class HotspotFeature
extends Feature {
    private static final class_310 CLIENT = class_310.method_1551();
    private static final double DISTANCE_TO_HOTSPOT_IN_BLOCKS = 10.0;
    private final HotspotRenderer renderer = new HotspotRenderer(this);
    private Double hotspotRadius = null;
    private Hotspot currentHotspot = null;
    private boolean bobberInHotspot = false;

    public HotspotFeature() {
        WorldEvents.JOIN.register(world -> this.reset());
        TickScheduler.getInstance().runRepeating(this::update, 2, TimeUnit.SECONDS);
        TickScheduler.getInstance().runRepeating(this::updateBobber, 500, TimeUnit.MILLISECONDS);
        NetworkEvents.PARTICLE_RECEIVED_PACKET.register(this::onParticleReceived);
        WorldRenderEvents.AFTER_TRANSLUCENT.register(this::render);
    }

    @Override
    public boolean isEnabled() {
        return SkyBlockAPI.isOnSkyBlock() && ConfigManager.getConfig().fishing.hotspotHighlight && SkyBlockAPI.isOnIslands(IslandType.CRIMSON_ISLE, IslandType.BACKWATER_BAYOU);
    }

    @Nullable
    Hotspot getCurrentHotspot() {
        return this.currentHotspot;
    }

    @Nullable
    Double getHotspotRadius() {
        return this.hotspotRadius;
    }

    boolean isBobberInHotspot() {
        return this.bobberInHotspot;
    }

    private void update() {
        if (!this.isEnabled() || HotspotFeature.CLIENT.field_1724 == null || HotspotFeature.CLIENT.field_1687 == null) {
            return;
        }
        class_1799 item = HotspotFeature.CLIENT.field_1724.method_31548().method_7391();
        if (item == null || item.method_7960() || !item.method_31574(class_1802.field_8378)) {
            this.reset();
            return;
        }
        if (this.currentHotspot == null) {
            this.currentHotspot = this.findClosestHotspotInRange((class_1297)HotspotFeature.CLIENT.field_1724).orElse(null);
            if (this.currentHotspot != null) {
                CaribouStonks.features().getFeature(HotspotRadarFeature.class).reset();
            }
        } else {
            Optional<Hotspot> newHotspot = this.findClosestHotspotInRange((class_1297)HotspotFeature.CLIENT.field_1724);
            if (newHotspot.isEmpty()) {
                this.reset();
            }
        }
    }

    private void updateBobber() {
        if (!this.isEnabled() || HotspotFeature.CLIENT.field_1724 == null) {
            return;
        }
        if (this.currentHotspot == null || this.hotspotRadius == null) {
            return;
        }
        class_1536 bobber = HotspotFeature.CLIENT.field_1724.field_7513;
        if (bobber != null && bobber.method_5805() && bobber.method_24921() == HotspotFeature.CLIENT.field_1724) {
            class_243 bobberPos = bobber.method_19538();
            double distanceToIgnoringY = PositionUtils.squaredDistanceToIgnoringY((class_2374)this.currentHotspot.centerPos(), (class_2374)bobberPos);
            this.bobberInHotspot = distanceToIgnoringY <= this.hotspotRadius * this.hotspotRadius;
        } else {
            this.bobberInHotspot = false;
        }
    }

    private void onParticleReceived(class_2675 particle) {
        if (!this.isEnabled() || this.currentHotspot == null || this.hotspotRadius != null) {
            return;
        }
        if (class_2398.field_11251.equals(particle.method_11551().method_10295()) && particle.method_11545() == 5 && particle.method_11543() == 0.0f) {
            class_243 particlePos = new class_243(particle.method_11544(), particle.method_11547(), particle.method_11546());
            this.hotspotRadius = this.currentHotspot.centerPos().method_1022(particlePos);
        }
    }

    private void render(WorldRenderContext context) {
        this.renderer.render(context);
    }

    private Optional<Hotspot> findClosestHotspotInRange(@Nullable class_1297 entity) {
        if (HotspotFeature.CLIENT.field_1687 == null || entity == null) {
            return Optional.empty();
        }
        List armorStands = HotspotFeature.CLIENT.field_1687.method_8390(class_1531.class, entity.method_5829().method_1014(10.0), class_1297::method_16914);
        class_1531 closestHotspotArmorStand = armorStands.stream().filter(as -> "HOTSPOT".equals(as.method_5477().getString())).min(Comparator.comparingDouble(as -> as.method_5858(entity))).orElse(null);
        if (closestHotspotArmorStand == null) {
            return Optional.empty();
        }
        Optional<String> perk = armorStands.stream().filter(e -> e.method_23317() == closestHotspotArmorStand.method_23317() && e.method_23318() < closestHotspotArmorStand.method_23318() && closestHotspotArmorStand.method_23318() - e.method_23318() <= 1.0 && e.method_23321() == closestHotspotArmorStand.method_23321() && e.method_36455() == closestHotspotArmorStand.method_36455()).map(e -> e.method_5477().getString()).findFirst();
        class_243 centerPos = closestHotspotArmorStand.method_24515().method_46558();
        return Optional.of(new Hotspot(closestHotspotArmorStand, centerPos, perk));
    }

    private void reset() {
        this.currentHotspot = null;
        this.hotspotRadius = null;
        this.bobberInHotspot = false;
    }
}

