/*
 * Decompiled with CFR 0.152.
 */
package fr.siroz.cariboustonks.feature.fishing;

import fr.siroz.cariboustonks.feature.fishing.HotspotFeature;
import fr.siroz.cariboustonks.util.colors.Color;
import fr.siroz.cariboustonks.util.colors.Colors;
import fr.siroz.cariboustonks.util.render.WorldRenderUtils;
import fr.siroz.cariboustonks.util.render.WorldRenderer;
import net.fabricmc.fabric.api.client.rendering.v1.WorldRenderContext;

class HotspotRenderer
implements WorldRenderer {
    private static final Color BOBBER_IN = Colors.GREEN.withAlpha(0.25f);
    private static final Color BOBBER_OUT = Colors.RED.withAlpha(0.25f);
    private final HotspotFeature hotspotFeature;

    HotspotRenderer(HotspotFeature hotspotFeature) {
        this.hotspotFeature = hotspotFeature;
    }

    @Override
    public void render(WorldRenderContext context) {
        if (!this.hotspotFeature.isEnabled() || this.hotspotFeature.getCurrentHotspot() == null) {
            return;
        }
        Double hotspotRadius = this.hotspotFeature.getHotspotRadius();
        if (hotspotRadius == null || hotspotRadius <= 0.0 || hotspotRadius > 16.0) {
            return;
        }
        WorldRenderUtils.renderThickCircle(context, this.hotspotFeature.getCurrentHotspot().centerPos().method_1023(0.0, 2.5, 0.0), hotspotRadius, 1.0, 32, this.hotspotFeature.isBobberInHotspot() ? BOBBER_IN : BOBBER_OUT, true);
    }
}

