/*
 * Decompiled with CFR 0.152.
 */
package fr.siroz.cariboustonks.feature.garden;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import fr.siroz.cariboustonks.core.skyblock.IslandType;
import fr.siroz.cariboustonks.core.skyblock.SkyBlockAPI;
import fr.siroz.cariboustonks.event.WorldEvents;
import fr.siroz.cariboustonks.feature.Feature;
import fr.siroz.cariboustonks.manager.command.CommandRegistration;
import fr.siroz.cariboustonks.manager.keybinds.KeyBind;
import fr.siroz.cariboustonks.manager.keybinds.KeyBindRegistration;
import fr.siroz.cariboustonks.util.Client;
import java.util.List;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandManager;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_5250;
import net.minecraft.class_7157;
import org.jetbrains.annotations.NotNull;

public final class MouseLockFeature
extends Feature
implements KeyBindRegistration,
CommandRegistration {
    private boolean locked = false;

    public MouseLockFeature() {
        WorldEvents.JOIN.register(world -> this.onJoinWorld());
    }

    @Override
    public boolean isEnabled() {
        return SkyBlockAPI.isOnSkyBlock() && SkyBlockAPI.getIsland() == IslandType.GARDEN;
    }

    @Override
    @NotNull
    public List<KeyBind> registerKeyBinds() {
        return List.of(new KeyBind("Lock Mouse", 45, true, this::updateLockState));
    }

    @Override
    public void register(@NotNull CommandDispatcher<FabricClientCommandSource> dispatcher, @NotNull class_7157 registryAccess) {
        dispatcher.register((LiteralArgumentBuilder)ClientCommandManager.literal((String)"cariboustonks").then(ClientCommandManager.literal((String)"lockMouse").executes(context -> {
            this.updateLockState();
            return 1;
        })));
    }

    public boolean isLocked() {
        return this.locked;
    }

    private void onJoinWorld() {
        if (this.locked) {
            this.locked = false;
            Client.sendMessageWithPrefix((class_2561)class_2561.method_43470((String)"La sourie n'est plus bloqu\u00e9 du a un changement de monde").method_27692(class_124.field_1061));
        }
    }

    private void updateLockState() {
        if (!this.isEnabled()) {
            return;
        }
        if (this.checkPlayerAndWorldIsNull()) {
            return;
        }
        this.locked = !this.locked;
        class_5250 extra = class_2561.method_43470((String)" (/cariboustonks lockMouse)").method_27695(new class_124[]{class_124.field_1080, class_124.field_1056});
        class_5250 message = this.locked ? class_2561.method_43470((String)"The Mouse is locked").method_27692(class_124.field_1061).method_10852((class_2561)extra) : class_2561.method_43470((String)"The Mouse is unlocked").method_27692(class_124.field_1060);
        Client.sendMessageWithPrefix((class_2561)message);
    }
}

