/*
 * Decompiled with CFR 0.152.
 */
package fr.siroz.cariboustonks.feature.item;

import fr.siroz.cariboustonks.config.ConfigManager;
import fr.siroz.cariboustonks.core.skyblock.SkyBlockAPI;
import fr.siroz.cariboustonks.event.CustomScreenEvents;
import fr.siroz.cariboustonks.event.ItemRenderEvents;
import fr.siroz.cariboustonks.event.MouseEvents;
import fr.siroz.cariboustonks.feature.Feature;
import fr.siroz.cariboustonks.mixin.accessors.OrderedTextTooltipComponentAccessor;
import fr.siroz.cariboustonks.util.cooldown.Cooldown;
import fr.siroz.cariboustonks.util.math.MathUtils;
import java.util.List;
import java.util.concurrent.TimeUnit;
import net.minecraft.class_2583;
import net.minecraft.class_310;
import net.minecraft.class_3675;
import net.minecraft.class_5224;
import net.minecraft.class_5481;
import net.minecraft.class_5683;
import net.minecraft.class_5684;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ScrollableTooltipFeature
extends Feature {
    private static final class_310 CLIENT = class_310.method_1551();
    private static final Cooldown COOLDOWN = Cooldown.of(100L, TimeUnit.MILLISECONDS);
    private static final int SCROLL_AMOUNT = 10;
    private static final double SMOOTHNESS_MULTIPLIER = 0.25;
    private double currentXOffset = 0.0;
    private double currentYOffset = 0.0;
    private double xOffset = 0.0;
    private double yOffset = 0.0;
    private List<class_5684> currentTooltips;

    public ScrollableTooltipFeature() {
        CustomScreenEvents.CLOSE.register(screen -> this.reset());
        MouseEvents.MOUSE_SCROLL.register(this::onMouseScroll);
        ItemRenderEvents.TOOLTIP_TRACKER.register(this::onTooltipTracker);
    }

    @Override
    public boolean isEnabled() {
        return SkyBlockAPI.isOnSkyBlock() && ConfigManager.getConfig().uiAndVisuals.scrollableTooltip.enabled;
    }

    public int getXOffset() {
        return this.isEnabled() ? MathUtils.floor(this.currentXOffset) : 0;
    }

    public int getYOffset() {
        return this.isEnabled() ? MathUtils.floor(this.currentYOffset) : 0;
    }

    private void reset() {
        this.resetScroll();
        this.currentTooltips = null;
    }

    private boolean onMouseScroll(double horizontal, double vertical) {
        boolean stopScroll = false;
        if (!this.isEnabled()) {
            return stopScroll;
        }
        if (class_3675.method_15987((long)CLIENT.method_22683().method_4490(), (int)340)) {
            if (vertical > 0.0) {
                this.scrollLeft();
            } else if (vertical < 0.0) {
                this.scrollRight();
            }
        } else if (vertical > 0.0) {
            if (this.isReverseScroll()) {
                this.scrollDown();
            } else {
                this.scrollUp();
            }
        } else if (vertical < 0.0) {
            if (this.isReverseScroll()) {
                this.scrollUp();
            } else {
                this.scrollDown();
            }
        }
        if (horizontal > 0.0) {
            this.scrollLeft();
        } else if (horizontal < 0.0) {
            this.scrollRight();
        }
        return stopScroll;
    }

    private boolean isReverseScroll() {
        return ConfigManager.getConfig().uiAndVisuals.scrollableTooltip.reverseScroll;
    }

    private void onTooltipTracker(List<class_5684> tooltipComponents) {
        if (!this.isEnabled()) {
            return;
        }
        if (COOLDOWN.testSilently()) {
            this.resetScroll();
        }
        COOLDOWN.reset();
        this.update();
        this.setTooltipComponents(tooltipComponents);
    }

    private void update() {
        this.currentXOffset += (this.xOffset - this.currentXOffset) * 0.25;
        this.currentYOffset += (this.yOffset - this.currentYOffset) * 0.25;
    }

    private void setTooltipComponents(List<class_5684> tooltipComponents) {
        if (!this.isEqual(this.currentTooltips, tooltipComponents)) {
            this.resetScroll();
            this.currentTooltips = tooltipComponents;
        }
    }

    private void scrollUp() {
        if (!COOLDOWN.testSilently()) {
            this.yOffset -= 10.0;
        }
    }

    private void scrollDown() {
        if (!COOLDOWN.testSilently()) {
            this.yOffset += 10.0;
        }
    }

    private void scrollLeft() {
        if (!COOLDOWN.testSilently()) {
            this.xOffset -= 10.0;
        }
    }

    private void scrollRight() {
        if (!COOLDOWN.testSilently()) {
            this.xOffset += 10.0;
        }
    }

    private void resetScroll() {
        this.currentXOffset = 0.0;
        this.currentYOffset = 0.0;
        this.xOffset = 0.0;
        this.yOffset = 0.0;
    }

    private boolean isEqual(@Nullable List<class_5684> item1, @Nullable List<class_5684> item2) {
        if (item1 == null || item2 == null || item1.size() != item2.size()) {
            return false;
        }
        for (int i = 0; i < item1.size(); ++i) {
            String text2;
            String text1;
            if (item1.get(i) instanceof class_5683 && !(item2.get(i) instanceof class_5683)) {
                return false;
            }
            if (item2.get(i) instanceof class_5683 && !(item1.get(i) instanceof class_5683)) {
                return false;
            }
            if (!(item1.get(i) instanceof class_5683) && !(item2.get(i) instanceof class_5683) || (text1 = OrderedTextReader.read(((OrderedTextTooltipComponentAccessor)item1.get(i)).getText())).equals(text2 = OrderedTextReader.read(((OrderedTextTooltipComponentAccessor)item2.get(i)).getText()))) continue;
            return false;
        }
        return true;
    }

    private static final class OrderedTextReader {
        private OrderedTextReader() {
        }

        @NotNull
        public static String read(@NotNull class_5481 text) {
            Visitor visitor = new Visitor();
            text.accept((class_5224)visitor);
            return visitor.getString();
        }

        private static class Visitor
        implements class_5224 {
            private int finalIndex = -1;
            private final StringBuilder builder = new StringBuilder();

            Visitor() {
            }

            public boolean accept(int index, class_2583 style, int codePoint) {
                if (index <= this.finalIndex) {
                    return false;
                }
                this.finalIndex = index;
                this.builder.append((char)codePoint);
                return true;
            }

            @Contract(pure=true)
            @NotNull
            public String getString() {
                return this.builder.toString();
            }
        }
    }
}

