/*
 * Decompiled with CFR 0.152.
 */
package fr.siroz.cariboustonks.feature.reminders;

import fr.siroz.cariboustonks.CaribouStonks;
import fr.siroz.cariboustonks.config.ConfigManager;
import fr.siroz.cariboustonks.core.skyblock.SkyBlockAPI;
import fr.siroz.cariboustonks.feature.Feature;
import fr.siroz.cariboustonks.manager.container.ContainerMatcherTrait;
import fr.siroz.cariboustonks.manager.container.overlay.ContainerOverlay;
import fr.siroz.cariboustonks.manager.reminder.Reminder;
import fr.siroz.cariboustonks.manager.reminder.ReminderDisplay;
import fr.siroz.cariboustonks.manager.reminder.ReminderManager;
import fr.siroz.cariboustonks.manager.reminder.TimedObject;
import fr.siroz.cariboustonks.util.Client;
import fr.siroz.cariboustonks.util.ItemUtils;
import fr.siroz.cariboustonks.util.TimeUtils;
import fr.siroz.cariboustonks.util.colors.Colors;
import fr.siroz.cariboustonks.util.render.gui.ColorHighlight;
import fr.siroz.cariboustonks.util.render.notification.Notification;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.time.Duration;
import java.time.Instant;
import java.util.List;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.class_124;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_5250;
import org.jetbrains.annotations.NotNull;

public final class ChocolateLimitReminderFeature
extends Feature
implements ContainerMatcherTrait,
Reminder,
ContainerOverlay {
    private static final Pattern TITLE_PATTERN = Pattern.compile("^Chocolate Factory$");
    private static final Pattern CHOCOLATE_PATTERN = Pattern.compile("^([\\d,]+) Chocolate$");
    private static final Pattern CHOCOLATE_SECOND_PATTERN = Pattern.compile("([\\d,.]+) Chocolate per second");
    private static final Pattern TIME_TOWER_ACTIVE_PATTERN = Pattern.compile("Status: (ACTIVE)");
    private static final int TIME_TOWER_SLOT = 39;
    private static final int CHOCOLATE_SLOT = 13;
    private static final int COCOA_BEAM_SLOT = 45;
    private static final long MAX_CHOCOLATE = 60000000000L;
    private static final class_1799 ICON = new class_1799((class_1935)class_1802.field_8116);
    private long totalChocolate = -1L;
    private double chocolatePerSeconds = -1.0;
    private Instant limitTime = null;

    @Override
    public boolean isEnabled() {
        return SkyBlockAPI.isOnSkyBlock() && ConfigManager.getConfig().general.reminders.chocolateFactoryMaxChocolates;
    }

    @Override
    public Pattern getTitlePattern() {
        return TITLE_PATTERN;
    }

    @Override
    @NotNull
    public String reminderType() {
        return "MAX_CHOCOLATE";
    }

    @Override
    @NotNull
    public ReminderDisplay display() {
        return ReminderDisplay.of((class_2561)class_2561.method_43470((String)"Max Chocolate Factory").method_27695(new class_124[]{class_124.field_1065, class_124.field_1067, class_124.field_1073}), (class_2561)class_2561.method_43470((String)"The chocolate limit is reached!").method_27692(class_124.field_1061), ICON);
    }

    @Override
    public void onExpire(@NotNull TimedObject timedObject) {
        class_5250 text = class_2561.method_43470((String)"The chocolate limit is reached!").method_27695(new class_124[]{class_124.field_1070, class_124.field_1061});
        Client.sendMessageWithPrefix((class_2561)class_2561.method_43470((String)"[Chocolate Factory] ").method_27692(class_124.field_1065).method_10852((class_2561)text));
        Notification.show(class_2561.method_43470((String)"Chocolate Factory\n").method_27695(new class_124[]{class_124.field_1065, class_124.field_1067}).method_10852((class_2561)text), ICON);
    }

    @Override
    public Optional<Duration> preNotifyDuration() {
        return Optional.of(Duration.ofHours(24L));
    }

    @Override
    public void onPreExpire(@NotNull TimedObject timedObject) {
        class_5250 text = class_2561.method_43470((String)"The chocolate limit will be reached soon!").method_27695(new class_124[]{class_124.field_1070, class_124.field_1061});
        Client.sendMessageWithPrefix((class_2561)class_2561.method_43470((String)"[Chocolate Factory] ").method_27692(class_124.field_1065).method_10852((class_2561)text));
        Notification.show(class_2561.method_43470((String)"Chocolate Factory\n").method_27695(new class_124[]{class_124.field_1065, class_124.field_1067}).method_10852((class_2561)text), ICON);
    }

    @Override
    @NotNull
    public List<ColorHighlight> content(@NotNull Int2ObjectMap<class_1799> slots) {
        String cocoaBeam;
        Matcher chocolateSecondMatcher;
        String info = ((class_1799)slots.get(13)).method_7964().getString();
        Matcher chocolateMatcher = CHOCOLATE_PATTERN.matcher(info);
        if (chocolateMatcher.find()) {
            this.totalChocolate = Long.parseLong(chocolateMatcher.group(1).replace(",", ""));
        }
        if ((chocolateSecondMatcher = CHOCOLATE_SECOND_PATTERN.matcher(cocoaBeam = ItemUtils.getConcatenatedLore((class_1799)slots.get(45)))).find()) {
            this.chocolatePerSeconds = Double.parseDouble(chocolateSecondMatcher.group(1).replace(",", ""));
        }
        if (this.totalChocolate > 0L && this.chocolatePerSeconds > 0.0) {
            Instant expirationTime;
            long remainingChocolate = 60000000000L - this.totalChocolate;
            long secondsToReachTotal = (long)Math.ceil((double)remainingChocolate / this.chocolatePerSeconds);
            Duration duration = Duration.ofSeconds(secondsToReachTotal);
            this.limitTime = expirationTime = Instant.now().plus(duration);
            String timeTower = ItemUtils.getConcatenatedLore((class_1799)slots.get(39));
            Matcher timeTowerActiveMatcher = TIME_TOWER_ACTIVE_PATTERN.matcher(timeTower);
            if (!timeTowerActiveMatcher.find()) {
                TimedObject timedObject = new TimedObject("cf::limit", "empty", expirationTime, this.reminderType());
                CaribouStonks.managers().getManager(ReminderManager.class).addTimedObject(timedObject, true);
            }
        }
        return List.of();
    }

    @Override
    public void render(@NotNull class_332 context, int screenWidth, int screenHeight, int x, int y) {
        if (this.limitTime != null) {
            class_5250 limitText = class_2561.method_43470((String)"Chocolate will be reached: ").method_27692(class_124.field_1065).method_10852((class_2561)class_2561.method_43470((String)TimeUtils.formatInstant(this.limitTime, TimeUtils.DATE_TIME_FULL)).method_27692(class_124.field_1054));
            context.method_27534(class_310.method_1551().field_1772, (class_2561)limitText, screenWidth >> 1, 20, Colors.WHITE.asInt());
        }
    }

    @Override
    public void reset() {
        this.totalChocolate = -1L;
        this.chocolatePerSeconds = -1.0;
        this.limitTime = null;
    }
}

