/*
 * Decompiled with CFR 0.152.
 */
package fr.siroz.cariboustonks.feature.stonks.graph;

import fr.siroz.cariboustonks.core.data.generic.ItemPrice;
import it.unimi.dsi.fastutil.objects.ObjectList;
import java.time.Duration;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public interface GraphDataFilter {
    public static List<ItemPrice> filterData(@NotNull ObjectList<ItemPrice> prices, @NotNull Granularity granularity) {
        Instant now = Instant.now();
        Instant threshold = switch (granularity.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> now.minus(1L, ChronoUnit.HOURS);
            case 1 -> now.minus(1L, ChronoUnit.DAYS);
            case 2 -> now.minus(7L, ChronoUnit.DAYS);
            case 3 -> now.minus(30L, ChronoUnit.DAYS);
        };
        List<ItemPrice> filteredPrices = prices.stream().filter(item -> !item.time().isBefore(threshold)).sorted(Comparator.comparing(ItemPrice::time)).toList();
        if (granularity == Granularity.WEEK || granularity == Granularity.MONTH) {
            LinkedHashMap<Instant, ItemPrice> sampledPoints = new LinkedHashMap<Instant, ItemPrice>();
            ChronoUnit unit = granularity == Granularity.WEEK ? ChronoUnit.HOURS : ChronoUnit.DAYS;
            for (ItemPrice item2 : filteredPrices) {
                Instant rounded = item2.time().truncatedTo(unit);
                ItemPrice closest = sampledPoints.getOrDefault(rounded, null);
                if (closest != null && Math.abs(Duration.between(item2.time(), rounded).toMillis()) >= Math.abs(Duration.between(closest.time(), rounded).toMillis())) continue;
                sampledPoints.put(rounded, item2);
            }
            ArrayList<ItemPrice> reducedPrices = new ArrayList<ItemPrice>(sampledPoints.values());
            if (!reducedPrices.contains(filteredPrices.getFirst())) {
                reducedPrices.addFirst(filteredPrices.getFirst());
            }
            if (!reducedPrices.contains(filteredPrices.getLast())) {
                reducedPrices.add(filteredPrices.getLast());
            }
            reducedPrices.sort(Comparator.comparing(ItemPrice::time));
            return reducedPrices;
        }
        return filteredPrices;
    }

    public static enum Granularity {
        HOUR,
        DAY,
        WEEK,
        MONTH;

    }
}

