/*
 * Decompiled with CFR 0.152.
 */
package fr.siroz.cariboustonks.feature.stonks.tooltips.auction;

import fr.siroz.cariboustonks.CaribouStonks;
import fr.siroz.cariboustonks.config.ConfigManager;
import fr.siroz.cariboustonks.core.data.generic.GenericDataSource;
import fr.siroz.cariboustonks.core.data.item.ItemLookupKey;
import fr.siroz.cariboustonks.core.skyblock.SkyBlockAPI;
import fr.siroz.cariboustonks.feature.Feature;
import fr.siroz.cariboustonks.feature.stonks.tooltips.TooltipPriceDisplayType;
import fr.siroz.cariboustonks.manager.container.ContainerMatcherTrait;
import fr.siroz.cariboustonks.manager.container.tooltip.ContainerTooltipAppender;
import fr.siroz.cariboustonks.util.NotEnoughUpdatesUtils;
import fr.siroz.cariboustonks.util.StonksUtils;
import java.lang.runtime.SwitchBootstraps;
import java.util.List;
import java.util.Optional;
import java.util.regex.Pattern;
import net.minecraft.class_124;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_437;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AuctionLowestBinTooltipFeature
extends Feature
implements ContainerMatcherTrait,
ContainerTooltipAppender {
    private final GenericDataSource genericDataSource;
    private final int priority;

    public AuctionLowestBinTooltipFeature(int priority) {
        this.priority = priority;
        this.genericDataSource = CaribouStonks.core().getGenericDataSource();
    }

    @Override
    public boolean isEnabled() {
        return SkyBlockAPI.isOnSkyBlock() && ConfigManager.getConfig().general.stonks.auctionTooltipPrice;
    }

    @Override
    @Nullable
    public Pattern getTitlePattern() {
        return null;
    }

    @Override
    public void appendToTooltip(@Nullable class_1735 focusedSlot, @NotNull class_1799 item, @NotNull List<class_2561> lines) {
        if (this.genericDataSource.isLowestBinsInUpdate()) {
            lines.add((class_2561)class_2561.method_43470((String)"Auction is currently updating...").method_27692(class_124.field_1061));
            return;
        }
        String neuId = NotEnoughUpdatesUtils.getNeuId(item);
        ItemLookupKey key = ItemLookupKey.ofNeuId(neuId);
        if (this.genericDataSource.hasLowestBin(key)) {
            TooltipPriceDisplayType displayType;
            Optional<Double> lowestBin = this.genericDataSource.getLowestBin(key);
            if (lowestBin.isEmpty()) {
                lines.add((class_2561)class_2561.method_43470((String)"Auction API error.").method_27692(class_124.field_1061));
                return;
            }
            int count = item.method_7947();
            double price = lowestBin.get();
            if (class_437.method_25442() && count > 1) {
                price *= (double)count;
            }
            TooltipPriceDisplayType tooltipPriceDisplayType = displayType = ConfigManager.getConfig().general.stonks.auctionTooltipPriceDisplayType;
            int n = 0;
            switch (SwitchBootstraps.enumSwitch("enumSwitch", new Object[]{"ALL", "SHORT", "FULL"}, (TooltipPriceDisplayType)tooltipPriceDisplayType, n)) {
                case 0: {
                    String lowestBinPriceDisplay = StonksUtils.INTEGER_NUMBERS.format(price);
                    String lowestBinPriceShortDisplay = StonksUtils.SHORT_FLOAT_NUMBERS.format(price);
                    lines.add((class_2561)class_2561.method_43470((String)"Auction Lowest BIN: ").method_27692(class_124.field_1054).method_10852((class_2561)class_2561.method_43470((String)(lowestBinPriceDisplay + " Coins")).method_27692(class_124.field_1065)).method_10852((class_2561)class_2561.method_43470((String)" (").method_27692(class_124.field_1080)).method_10852((class_2561)class_2561.method_43470((String)lowestBinPriceShortDisplay).method_27692(class_124.field_1065)).method_10852((class_2561)class_2561.method_43470((String)")").method_27692(class_124.field_1080)));
                    break;
                }
                case 1: {
                    String lowestBinPriceShortDisplay = StonksUtils.SHORT_FLOAT_NUMBERS.format(price);
                    lines.add((class_2561)class_2561.method_43470((String)"Auction Lowest BIN: ").method_27692(class_124.field_1054).method_10852((class_2561)class_2561.method_43470((String)(lowestBinPriceShortDisplay + " Coins")).method_27692(class_124.field_1065)));
                    break;
                }
                case 2: {
                    String lowestBinPriceDisplay = StonksUtils.INTEGER_NUMBERS.format(price);
                    lines.add((class_2561)class_2561.method_43470((String)"Auction Lowest BIN: ").method_27692(class_124.field_1054).method_10852((class_2561)class_2561.method_43470((String)(lowestBinPriceDisplay + " Coins")).method_27692(class_124.field_1065)));
                    break;
                }
            }
            if (!class_437.method_25442() && count > 1) {
                lines.add((class_2561)class_2561.method_43470((String)("[Press SHIFT for x" + count + "]")).method_27692(class_124.field_1063));
            }
        }
    }

    @Override
    public int getPriority() {
        return this.priority;
    }
}

