/*
 * Decompiled with CFR 0.152.
 */
package fr.siroz.cariboustonks.feature.waypoints;

import com.google.common.reflect.TypeToken;
import fr.siroz.cariboustonks.CaribouStonks;
import fr.siroz.cariboustonks.core.skyblock.IslandType;
import fr.siroz.cariboustonks.core.skyblock.SkyBlockAPI;
import fr.siroz.cariboustonks.feature.Feature;
import fr.siroz.cariboustonks.manager.waypoint.Waypoint;
import fr.siroz.cariboustonks.util.render.WorldRenderer;
import java.lang.reflect.Type;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientLifecycleEvents;
import net.fabricmc.fabric.api.client.rendering.v1.WorldRenderContext;
import net.fabricmc.fabric.api.client.rendering.v1.WorldRenderEvents;
import net.minecraft.class_310;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public final class WaypointFeature
extends Feature
implements WorldRenderer {
    private static final Path WAYPOINT_PATH = CaribouStonks.CONFIG_DIR.resolve("waypoints.json");
    private Map<IslandType, List<Waypoint>> waypoints = Arrays.stream(IslandType.VALUES).collect(Collectors.toMap(Function.identity(), l -> new ArrayList(), (a, b) -> a, () -> new EnumMap(IslandType.class)));

    public WaypointFeature() {
        ClientLifecycleEvents.CLIENT_STARTED.register(this::onClientStarted);
        ClientLifecycleEvents.CLIENT_STOPPING.register(this::saveWaypoints);
        WorldRenderEvents.AFTER_TRANSLUCENT.register(this::render);
    }

    @Override
    public boolean isEnabled() {
        return SkyBlockAPI.isOnSkyBlock();
    }

    @Override
    public void render(WorldRenderContext context) {
        if (!this.isEnabled()) {
            return;
        }
        if (this.waypoints.isEmpty()) {
            return;
        }
        ArrayList currentWaypoints = new ArrayList(this.waypoints.get((Object)SkyBlockAPI.getIsland()));
        currentWaypoints.addAll(new ArrayList(this.waypoints.get((Object)IslandType.ANY)));
        if (currentWaypoints.isEmpty()) {
            return;
        }
        for (Waypoint waypoint : currentWaypoints) {
            waypoint.getRenderer().render(context);
        }
    }

    @Contract(value=" -> new")
    @NotNull
    public Map<IslandType, List<Waypoint>> getWaypoints() {
        return new EnumMap<IslandType, List<Waypoint>>(this.waypoints);
    }

    public void updateWaypoints(Map<IslandType, List<Waypoint>> newWaypoints) {
        if (newWaypoints == null || newWaypoints.isEmpty()) {
            return;
        }
        EnumMap<IslandType, List<Waypoint>> copy = new EnumMap<IslandType, List<Waypoint>>(IslandType.class);
        IslandType[] islandTypeArray = IslandType.values();
        int n = islandTypeArray.length;
        for (int i = 0; i < n; ++i) {
            IslandType islandType;
            List<Waypoint> waypointsList = newWaypoints.get((Object)(islandType = islandTypeArray[i]));
            copy.put(islandType, waypointsList != null ? new ArrayList<Waypoint>(waypointsList) : new ArrayList());
        }
        this.waypoints = copy;
    }

    private void onClientStarted(class_310 client) {
        this.loadWaypoints().thenAccept(this::loadExistingWaypoints);
    }

    private CompletableFuture<Map<IslandType, List<Waypoint>>> loadWaypoints() {
        if (!Files.exists(WAYPOINT_PATH, new LinkOption[0])) {
            return CompletableFuture.completedFuture(Map.of());
        }
        return CompletableFuture.supplyAsync(() -> {
            Type mapType = new TypeToken<Map<IslandType, List<Waypoint>>>(){}.getType();
            return CaribouStonks.core().getJsonFileService().loadMap(WAYPOINT_PATH, mapType);
        });
    }

    private void loadExistingWaypoints(@NotNull Map<IslandType, List<Waypoint>> waypointMap) {
        int loaded = 0;
        for (Map.Entry<IslandType, List<Waypoint>> entry : waypointMap.entrySet()) {
            if (entry.getValue() == null) {
                waypointMap.put(entry.getKey(), new ArrayList());
            }
            loaded += entry.getValue().size();
        }
        CaribouStonks.LOGGER.info("[Waypoints] Loaded {} waypoints", (Object)loaded);
        this.waypoints.putAll(waypointMap);
    }

    public void saveWaypoints(class_310 client) {
        CaribouStonks.core().getJsonFileService().save(WAYPOINT_PATH, this.waypoints);
    }
}

