/*
 * Decompiled with CFR 0.152.
 */
package fr.siroz.cariboustonks.manager;

import fr.siroz.cariboustonks.feature.Feature;
import fr.siroz.cariboustonks.manager.Manager;
import fr.siroz.cariboustonks.manager.command.CommandManager;
import fr.siroz.cariboustonks.manager.container.overlay.ContainerOverlayManager;
import fr.siroz.cariboustonks.manager.container.tooltip.ContainerTooltipAppenderManager;
import fr.siroz.cariboustonks.manager.hud.HudManager;
import fr.siroz.cariboustonks.manager.keybinds.KeyBindManager;
import fr.siroz.cariboustonks.manager.network.NetworkManager;
import fr.siroz.cariboustonks.manager.reminder.ReminderManager;
import fr.siroz.cariboustonks.manager.waypoint.WaypointManager;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientLifecycleEvents;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

public final class Managers {
    private static final Map<Class<? extends Manager>, Manager> MANAGER_INSTANCES = new ConcurrentHashMap<Class<? extends Manager>, Manager>();

    @ApiStatus.Internal
    public Managers() {
        ClientLifecycleEvents.CLIENT_STOPPING.register(client -> this.onStop());
        this.register(new CommandManager());
        this.register(new KeyBindManager());
        this.register(new WaypointManager());
        this.register(new ReminderManager());
        this.register(new NetworkManager());
        this.register(new ContainerOverlayManager());
        this.register(new ContainerTooltipAppenderManager());
        this.register(new HudManager());
    }

    @NotNull
    public <T extends Manager> T getManager(@NotNull Class<T> managerClass) {
        Manager manager = MANAGER_INSTANCES.get(managerClass);
        if (manager == null) {
            throw new IllegalArgumentException("Manager not found: " + managerClass.getSimpleName());
        }
        return (T)manager;
    }

    @ApiStatus.Internal
    public void handleFeatureRegistration(@NotNull Feature feature) {
        for (Manager manager : MANAGER_INSTANCES.values()) {
            manager.register(feature);
        }
    }

    private void register(@NotNull Manager manager) {
        MANAGER_INSTANCES.put(manager.getClass(), manager);
        manager.onInit();
    }

    private void onStop() {
        for (Manager manager : MANAGER_INSTANCES.values()) {
            manager.onShutdown();
        }
    }
}

