/*
 * Decompiled with CFR 0.152.
 */
package fr.siroz.cariboustonks.manager.container.overlay;

import fr.siroz.cariboustonks.CaribouStonks;
import fr.siroz.cariboustonks.core.crash.CrashType;
import fr.siroz.cariboustonks.core.skyblock.SkyBlockAPI;
import fr.siroz.cariboustonks.feature.Feature;
import fr.siroz.cariboustonks.manager.Manager;
import fr.siroz.cariboustonks.manager.container.ContainerMatcherTrait;
import fr.siroz.cariboustonks.manager.container.overlay.ContainerOverlay;
import fr.siroz.cariboustonks.mixin.accessors.HandledScreenAccessor;
import fr.siroz.cariboustonks.util.render.gui.ColorHighlight;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectRBTreeMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.List;
import net.fabricmc.fabric.api.client.screen.v1.ScreenEvents;
import net.minecraft.class_1707;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_476;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

public final class ContainerOverlayManager
implements Manager {
    private static final class_310 CLIENT = class_310.method_1551();
    private final Object2ObjectMap<Feature, ContainerOverlay> containerOverlayMap = new Object2ObjectOpenHashMap();
    private ContainerOverlay currentContainerOverlay = null;
    private List<ColorHighlight> highlights;

    @ApiStatus.Internal
    public ContainerOverlayManager() {
        ScreenEvents.BEFORE_INIT.register(this::onScreenBeforeInit);
    }

    @Override
    public void register(@NotNull Feature feature) {
        if (feature instanceof ContainerOverlay) {
            ContainerOverlay containerOverlay = (ContainerOverlay)((Object)feature);
            this.containerOverlayMap.put((Object)feature, (Object)containerOverlay);
        }
    }

    public void markHighlightsDirty() {
        this.highlights = null;
    }

    private void onScreenBeforeInit(class_310 _client, class_437 screen, int _scaledWidth, int _scaledHeight) {
        if (SkyBlockAPI.isOnSkyBlock() && screen instanceof class_476) {
            class_476 genericContainerScreen = (class_476)screen;
            ScreenEvents.afterRender((class_437)screen).register((_screen, drawContext, _mouseX, _mouseY, _tickDelta) -> {
                this.drawGlobal(drawContext);
                class_4587 matrices = drawContext.method_51448();
                matrices.method_22903();
                matrices.method_46416((float)((HandledScreenAccessor)genericContainerScreen).getX(), (float)((HandledScreenAccessor)genericContainerScreen).getY(), 300.0f);
                this.drawHighlights(drawContext, genericContainerScreen, (List<class_1735>)((class_1707)genericContainerScreen.method_17577()).field_7761);
                matrices.method_22909();
            });
            ScreenEvents.remove((class_437)screen).register(_screen -> this.clearScreen());
            this.onScreen(genericContainerScreen);
        } else {
            this.clearScreen();
        }
    }

    private void onScreen(@NotNull class_476 screen) {
        for (Object2ObjectMap.Entry overlay : this.containerOverlayMap.object2ObjectEntrySet()) {
            ContainerMatcherTrait trait;
            Object object;
            if (!((Feature)overlay.getKey()).isEnabled() || !((object = overlay.getKey()) instanceof ContainerMatcherTrait) || !(trait = (ContainerMatcherTrait)object).matches((class_437)screen)) continue;
            this.currentContainerOverlay = (ContainerOverlay)overlay.getValue();
            this.markHighlightsDirty();
            return;
        }
        this.clearScreen();
    }

    private void clearScreen() {
        if (this.currentContainerOverlay != null) {
            this.currentContainerOverlay.reset();
            this.currentContainerOverlay = null;
        }
    }

    private void drawGlobal(class_332 context) {
        if (this.currentContainerOverlay != null) {
            int screenWidth = CLIENT.method_22683().method_4486();
            int screenHeight = CLIENT.method_22683().method_4502();
            try {
                this.currentContainerOverlay.render(context, screenWidth, screenHeight, 0, 0);
            }
            catch (Throwable throwable) {
                CaribouStonks.core().reportCrash(CrashType.CONTAINER, this.currentContainerOverlay.getClass().getSimpleName(), this.currentContainerOverlay.getClass().getName(), "render", throwable);
            }
        }
    }

    private void drawHighlights(class_332 context, class_476 genericContainerScreen, List<class_1735> slots) {
        if (this.currentContainerOverlay == null) {
            return;
        }
        if (this.highlights == null) {
            this.highlights = this.currentContainerOverlay.content(this.slotMap(slots.subList(0, ((class_1707)genericContainerScreen.method_17577()).method_17388() * 9)));
        }
        for (ColorHighlight highlight : this.highlights) {
            class_1735 slot = slots.get(highlight.slot());
            context.method_25294(slot.field_7873, slot.field_7872, slot.field_7873 + 16, slot.field_7872 + 16, highlight.color().asInt());
        }
    }

    @NotNull
    private Int2ObjectMap<class_1799> slotMap(@NotNull List<class_1735> slots) {
        Int2ObjectRBTreeMap slotMap = new Int2ObjectRBTreeMap();
        for (int i = 0; i < slots.size(); ++i) {
            slotMap.put(i, (Object)slots.get(i).method_7677());
        }
        return slotMap;
    }
}

