/*
 * Decompiled with CFR 0.152.
 */
package fr.siroz.cariboustonks.manager.hud;

import fr.siroz.cariboustonks.CaribouStonks;
import fr.siroz.cariboustonks.feature.Feature;
import fr.siroz.cariboustonks.manager.Manager;
import fr.siroz.cariboustonks.manager.hud.Hud;
import fr.siroz.cariboustonks.manager.hud.HudProvider;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectList;
import java.util.List;
import net.fabricmc.fabric.api.client.rendering.v1.HudLayerRegistrationCallback;
import net.minecraft.class_2960;
import org.jetbrains.annotations.NotNull;

public final class HudManager
implements Manager {
    private final ObjectList<Hud> hudList = new ObjectArrayList();

    @Override
    public void register(@NotNull Feature feature) {
        if (feature instanceof HudProvider) {
            HudProvider hud = (HudProvider)((Object)feature);
            this.handleHudRegistration(hud);
        }
    }

    private void handleHudRegistration(@NotNull HudProvider provider) {
        class_2960 afterThis = (class_2960)provider.getAttachLayerAfter().left();
        class_2960 identifier = (class_2960)provider.getAttachLayerAfter().right();
        if (afterThis == null && identifier == null) {
            CaribouStonks.LOGGER.error("[HudManager] Failed to register HUD for {}. Both LEFT and RIGHT Attached Layers are null.", (Object)provider.getClass().getSimpleName());
            return;
        }
        if (afterThis == null) {
            CaribouStonks.LOGGER.error("[HudManager] Failed to register HUD for {}. LEFT Attached Layer is null.", (Object)provider.getClass().getSimpleName());
            return;
        }
        if (identifier == null) {
            CaribouStonks.LOGGER.error("[HudManager] Failed to register HUD for {}. RIGHT Attached Layer is null.", (Object)provider.getClass().getSimpleName());
            return;
        }
        Hud hud = provider.getHud();
        this.hudList.add((Object)hud);
        HudLayerRegistrationCallback.EVENT.register(wrapper -> wrapper.attachLayerAfter(afterThis, identifier, hud::renderHud));
    }

    public List<Hud> getHudList() {
        return this.hudList;
    }
}

