/*
 * Decompiled with CFR 0.152.
 */
package fr.siroz.cariboustonks.manager.hud;

import fr.siroz.cariboustonks.manager.hud.Hud;
import fr.siroz.cariboustonks.manager.hud.HudPosition;
import fr.siroz.cariboustonks.util.colors.Colors;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_4587;
import net.minecraft.class_5348;
import net.minecraft.class_9779;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Experimental
public final class TextListHud
extends Hud {
    private final List<class_2561> defaultText;
    private final Supplier<List<class_2561>> textSupplier;

    public TextListHud(@NotNull List<class_2561> defaultText, @NotNull Supplier<List<class_2561>> textSupplier, @NotNull HudPosition hudPosition, int defaultX, int defaultY) {
        super(hudPosition, defaultX, defaultY);
        if (defaultText.isEmpty()) {
            throw new IllegalArgumentException("The text list cannot be empty");
        }
        this.defaultText = defaultText;
        this.textSupplier = textSupplier;
    }

    @Override
    public int width() {
        return (int)((float)TextListHud.CLIENT.field_1772.method_27525((class_5348)this.defaultText.getFirst()) * this.scale());
    }

    @Override
    public int height() {
        Objects.requireNonNull(TextListHud.CLIENT.field_1772);
        return (int)(9.0f * this.scale());
    }

    @Override
    public void renderScreen(class_332 context) {
        this.render(this.defaultText, context, this.x(), this.y(), this.scale());
    }

    @Override
    public void renderHud(class_332 context, class_9779 tickCounter) {
        if (this.shouldRender()) {
            this.render(this.textSupplier.get(), context, this.hudPosition.x(), this.hudPosition.y(), this.hudPosition.scale());
        }
    }

    private void render(@NotNull List<class_2561> text, @NotNull class_332 context, int x, int y, float scale) {
        class_4587 matrices = context.method_51448();
        matrices.method_22903();
        matrices.method_22905(scale, scale, 0.0f);
        int baseY = (int)((float)y / scale);
        int offset = 0;
        for (int i = 0; i < text.size(); ++i) {
            Objects.requireNonNull(TextListHud.CLIENT.field_1772);
            int yLine = baseY + i * 9 + offset;
            context.method_51439(TextListHud.CLIENT.field_1772, text.get(i), (int)((float)x / scale), yLine, Colors.WHITE.asInt(), false);
            offset += 4;
        }
        matrices.method_22909();
    }
}

