/*
 * Decompiled with CFR 0.152.
 */
package fr.siroz.cariboustonks.manager.network;

import fr.siroz.cariboustonks.event.NetworkEvents;
import fr.siroz.cariboustonks.manager.Manager;
import fr.siroz.cariboustonks.util.math.MathUtils;
import java.util.Arrays;
import net.minecraft.class_156;
import net.minecraft.class_2596;
import net.minecraft.class_2935;
import net.minecraft.class_310;
import org.jetbrains.annotations.ApiStatus;

public final class NetworkManager
implements Manager {
    private static final class_310 CLIENT = class_310.method_1551();
    private long lastPingResult = 0L;
    private long displayedPing = 0L;
    private long lastUpdateTime = 0L;
    private final float[] tickRates = new float[20];
    private int nextIndex = 0;
    private long timeLastTimeUpdate = -1L;
    private long timeGameJoined = 0L;

    @ApiStatus.Internal
    public NetworkManager() {
        NetworkEvents.PING_RESULT.register(ping -> {
            this.lastPingResult = ping;
        });
        NetworkEvents.WORLD_TIME_UPDATE_PACKET.register(this::onWorldTimeUpdatePacket);
        NetworkEvents.GAME_JOIN_PACKET.register(this::onGameJoinPacket);
    }

    public long getPing() {
        long currentTime = System.currentTimeMillis();
        if (currentTime - this.lastUpdateTime >= 1500L) {
            this.displayedPing = this.lastPingResult;
            this.lastUpdateTime = currentTime;
        }
        return this.displayedPing;
    }

    public float getTickRate() {
        if (CLIENT == null || NetworkManager.CLIENT.field_1687 == null || NetworkManager.CLIENT.field_1724 == null) {
            return 0.0f;
        }
        if (System.currentTimeMillis() - this.timeGameJoined < 4000L) {
            return 20.0f;
        }
        int numTicks = 0;
        float sumTickRates = 0.0f;
        for (float tickRate : this.tickRates) {
            if (!(tickRate > 0.0f)) continue;
            sumTickRates += tickRate;
            ++numTicks;
        }
        return sumTickRates / (float)numTicks;
    }

    private void onWorldTimeUpdatePacket() {
        long now = System.currentTimeMillis();
        float timeElapsed = (float)(now - this.timeLastTimeUpdate) / 1000.0f;
        this.tickRates[this.nextIndex] = MathUtils.clamp(20.0f / timeElapsed, 0.0f, 20.0f);
        this.nextIndex = (this.nextIndex + 1) % this.tickRates.length;
        this.timeLastTimeUpdate = now;
    }

    private void onGameJoinPacket() {
        Arrays.fill(this.tickRates, 0.0f);
        this.nextIndex = 0;
        this.timeGameJoined = this.timeLastTimeUpdate = System.currentTimeMillis();
    }

    @Deprecated
    private void sendPingPacket() {
        if (NetworkManager.CLIENT.field_1724 == null || CLIENT.method_1562() == null) {
            return;
        }
        CLIENT.method_1562().method_52787((class_2596)new class_2935(class_156.method_658()));
    }
}

