/*
 * Decompiled with CFR 0.152.
 */
package fr.siroz.cariboustonks.manager.waypoint;

import fr.siroz.cariboustonks.CaribouStonks;
import fr.siroz.cariboustonks.manager.waypoint.WaypointManager;
import fr.siroz.cariboustonks.manager.waypoint.WaypointRenderer;
import fr.siroz.cariboustonks.manager.waypoint.options.IconOption;
import fr.siroz.cariboustonks.manager.waypoint.options.TextOption;
import fr.siroz.cariboustonks.util.Ticks;
import fr.siroz.cariboustonks.util.colors.Color;
import fr.siroz.cariboustonks.util.colors.Colors;
import fr.siroz.cariboustonks.util.position.Position;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import net.minecraft.class_238;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Range;

public final class Waypoint {
    private Position position;
    private class_238 box;
    private Type type;
    private boolean enabled;
    private final UUID uuid;
    private int timeoutTicks;
    private final boolean resetBetweenWorlds;
    private Color color;
    private float alpha;
    private final float boxLineWidth;
    private final boolean boxThroughBlocks;
    private final Consumer<Waypoint> destroyListener;
    private final TextOption textOption;
    private final IconOption iconOption;
    private final WaypointRenderer renderer;

    private Waypoint(@NotNull Position position, @NotNull Type type, boolean enabled, @NotNull UUID uuid, int timeoutTicks, boolean resetBetweenWorlds, @NotNull Color color, float alpha, float boxLineWidth, boolean boxThroughBlocks, @Nullable Consumer<Waypoint> destroyListener, @NotNull TextOption textOption, @NotNull IconOption iconOption) {
        this.position = position;
        this.box = new class_238(position.toBlockPos());
        this.type = type;
        this.enabled = enabled;
        this.uuid = uuid;
        this.timeoutTicks = timeoutTicks;
        this.resetBetweenWorlds = resetBetweenWorlds;
        this.color = color;
        this.alpha = alpha;
        this.boxLineWidth = boxLineWidth;
        this.boxThroughBlocks = boxThroughBlocks;
        this.destroyListener = destroyListener;
        this.textOption = textOption;
        this.iconOption = iconOption;
        this.renderer = new WaypointRenderer(this);
    }

    @Contract(value="_ -> new", pure=true)
    @NotNull
    public static Builder builder(@NotNull Position position) {
        return new Builder(position);
    }

    public static Waypoint builder(@NotNull Consumer<Builder> builderConsumer) {
        Builder builder = Waypoint.builder(Position.ORIGIN);
        builderConsumer.accept(builder);
        return builder.build();
    }

    @NotNull
    public Position getPosition() {
        return this.position;
    }

    public void updatePosition(@NotNull Position position) {
        this.position = position;
        this.box = new class_238(position.toBlockPos());
    }

    public void updateType(@NotNull Type type) {
        this.type = type;
    }

    public class_238 getBox() {
        return this.box;
    }

    @NotNull
    public Type getType() {
        return this.type;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    @NotNull
    public UUID getUuid() {
        return this.uuid;
    }

    @ApiStatus.Internal
    int getTimeoutTicks() {
        return this.timeoutTicks;
    }

    @ApiStatus.Internal
    void decreaseTimeout() {
        if (this.timeoutTicks > 0) {
            --this.timeoutTicks;
        }
    }

    boolean isResetBetweenWorlds() {
        return this.resetBetweenWorlds;
    }

    @NotNull
    public Color getColor() {
        return this.color;
    }

    public void updateColor(@NotNull Color color) {
        this.color = color;
    }

    public float getAlpha() {
        return this.alpha;
    }

    public void updateAlpha(float alpha) {
        this.alpha = alpha;
    }

    public float getBoxLineWidth() {
        return this.boxLineWidth;
    }

    public boolean isBoxThroughBlocks() {
        return this.boxThroughBlocks;
    }

    public void destroy() {
        if (this.destroyListener != null) {
            this.destroyListener.accept(this);
        }
        CaribouStonks.managers().getManager(WaypointManager.class).removeWaypoint(this);
    }

    public TextOption getTextOption() {
        return this.textOption;
    }

    public IconOption getIconOption() {
        return this.iconOption;
    }

    public WaypointRenderer getRenderer() {
        return this.renderer;
    }

    public static enum Type {
        BEAM,
        WAYPOINT,
        OUTLINED_WAYPOINT,
        HIGHLIGHT,
        OUTLINED_HIGHLIGHT,
        OUTLINE;

    }

    public static class Builder {
        private Position position;
        private Type waypointType = Type.WAYPOINT;
        private boolean enabled = true;
        private UUID uuid = UUID.randomUUID();
        private int timeoutTicks = -1;
        private boolean resetBetweenWorlds = false;
        private float alpha = 0.5f;
        private Color color = Colors.RED;
        private float boxLineWidth = 5.0f;
        private boolean boxThroughBlocks = true;
        private Consumer<Waypoint> destroyListener = null;
        private TextOption textOption = new TextOption();
        private IconOption iconOption = new IconOption();

        public Builder(@NotNull Position position) {
            this.position = position;
        }

        public Builder position(@NotNull Position position) {
            this.position = position;
            return this;
        }

        public Builder type(@NotNull Type waypointType) {
            this.waypointType = waypointType;
            return this;
        }

        public Builder enabled(boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public Builder uuid(@NotNull UUID uuid) {
            this.uuid = uuid;
            return this;
        }

        public Builder timeout(@Range(from=1L, to=999L) int timeout, @NotNull TimeUnit unit) {
            this.timeoutTicks = Ticks.from(timeout, unit);
            return this;
        }

        public Builder resetBetweenWorlds(boolean resetBetweenWorlds) {
            this.resetBetweenWorlds = resetBetweenWorlds;
            return this;
        }

        public Builder color(@NotNull Color color) {
            this.color = color;
            return this;
        }

        public Builder alpha(float alpha) {
            this.alpha = alpha;
            return this;
        }

        public Builder boxLineWidth(float boxLineWidth) {
            this.boxLineWidth = boxLineWidth;
            return this;
        }

        public Builder boxThroughBlocks(boolean boxThroughBlocks) {
            this.boxThroughBlocks = boxThroughBlocks;
            return this;
        }

        public Builder destroyListener(@NotNull Consumer<Waypoint> destroyListener) {
            this.destroyListener = destroyListener;
            return this;
        }

        public Builder textOption(@NotNull TextOption textOption) {
            this.textOption = textOption;
            return this;
        }

        public Builder iconOption(@NotNull IconOption iconOption) {
            this.iconOption = iconOption;
            return this;
        }

        public Waypoint build() {
            return new Waypoint(this.position, this.waypointType, this.enabled, this.uuid, this.timeoutTicks, this.resetBetweenWorlds, this.color, this.alpha, this.boxLineWidth, this.boxThroughBlocks, this.destroyListener, this.textOption, this.iconOption);
        }

        public Waypoint buildAndRegister() {
            Waypoint waypoint = this.build();
            CaribouStonks.managers().getManager(WaypointManager.class).addWaypoint(waypoint);
            return waypoint;
        }
    }
}

