/*
 * Decompiled with CFR 0.152.
 */
package fr.siroz.cariboustonks.manager.waypoint;

import fr.siroz.cariboustonks.core.scheduler.TickScheduler;
import fr.siroz.cariboustonks.event.WorldEvents;
import fr.siroz.cariboustonks.manager.Manager;
import fr.siroz.cariboustonks.manager.waypoint.Waypoint;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.fabricmc.fabric.api.client.rendering.v1.WorldRenderContext;
import net.fabricmc.fabric.api.client.rendering.v1.WorldRenderEvents;
import net.minecraft.class_310;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

public final class WaypointManager
implements Manager {
    private static final class_310 CLIENT = class_310.method_1551();
    private final Map<UUID, Waypoint> waypoints = new ConcurrentHashMap<UUID, Waypoint>();

    @ApiStatus.Internal
    public WaypointManager() {
        WorldEvents.JOIN.register(world -> this.resetWaypoints());
        WorldRenderEvents.AFTER_TRANSLUCENT.register(this::render);
        TickScheduler.getInstance().runRepeating(this::onTick, 1);
    }

    public void addWaypoint(@NotNull Waypoint waypoint) {
        this.waypoints.putIfAbsent(waypoint.getUuid(), waypoint);
    }

    public void removeWaypoint(@NotNull Waypoint waypoint) {
        this.waypoints.remove(waypoint.getUuid());
    }

    private void render(WorldRenderContext context) {
        if (WaypointManager.CLIENT.field_1724 == null || WaypointManager.CLIENT.field_1687 == null || this.waypoints.isEmpty()) {
            return;
        }
        for (Map.Entry<UUID, Waypoint> waypoint : this.waypoints.entrySet()) {
            waypoint.getValue().getRenderer().render(context);
        }
    }

    private void onTick() {
        if (this.waypoints.isEmpty()) {
            return;
        }
        for (Map.Entry<UUID, Waypoint> waypoint : this.waypoints.entrySet()) {
            if (waypoint.getValue().getTimeoutTicks() == -1) continue;
            waypoint.getValue().decreaseTimeout();
            if (waypoint.getValue().getTimeoutTicks() != 0) continue;
            waypoint.getValue().destroy();
        }
    }

    private void resetWaypoints() {
        for (Map.Entry<UUID, Waypoint> waypoint : this.waypoints.entrySet()) {
            if (!waypoint.getValue().isResetBetweenWorlds()) continue;
            waypoint.getValue().destroy();
        }
    }
}

