/*
 * Decompiled with CFR 0.152.
 */
package fr.siroz.cariboustonks.screen.reminders;

import fr.siroz.cariboustonks.manager.reminder.Reminder;
import fr.siroz.cariboustonks.manager.reminder.TimedObject;
import fr.siroz.cariboustonks.screen.reminders.ReminderScreen;
import fr.siroz.cariboustonks.util.StonksUtils;
import fr.siroz.cariboustonks.util.TimeUtils;
import fr.siroz.cariboustonks.util.colors.Colors;
import it.unimi.dsi.fastutil.Pair;
import java.time.Instant;
import net.minecraft.class_124;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_350;
import net.minecraft.class_4280;
import net.minecraft.class_5348;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class ReminderListWidget
extends class_4280<Entry> {
    private final ReminderScreen parent;

    ReminderListWidget(class_310 client, @NotNull ReminderScreen parent, int width, int height, int y, int itemHeight) {
        super(client, width, height, y, itemHeight);
        this.parent = parent;
        if (parent.reminders.isEmpty()) {
            this.method_25321((class_350.class_351)new NothingToShow());
        } else {
            for (Pair<Reminder, TimedObject> reminder : parent.reminders) {
                this.method_25321((class_350.class_351)new ReminderEntry(reminder));
            }
        }
    }

    public int method_25322() {
        return 270;
    }

    public void setSelected(@Nullable Entry entry) {
        super.method_25313((class_350.class_351)entry);
        Pair<Reminder, TimedObject> item = null;
        if (entry instanceof ReminderEntry) {
            ReminderEntry reminderEntry = (ReminderEntry)entry;
            item = reminderEntry.reminder;
        }
        this.parent.itemSelected(item);
    }

    protected class NothingToShow
    extends Entry {
        private static final class_2561 TEXT = class_2561.method_43470((String)"No reminders for the moment ;'(");

        protected NothingToShow() {
        }

        public class_2561 method_37006() {
            return class_2561.method_43470((String)"Nothing to show");
        }

        public void method_25343(class_332 context, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean hovered, float tickProgress) {
            if (ReminderListWidget.this.field_22740 == null || ((ReminderListWidget)ReminderListWidget.this).field_22740.field_1755 == null || ((ReminderListWidget)ReminderListWidget.this).field_22740.field_1772 == null) {
                return;
            }
            int x1 = (((ReminderListWidget)ReminderListWidget.this).field_22740.field_1755.field_22789 - ((ReminderListWidget)ReminderListWidget.this).field_22740.field_1772.method_27525((class_5348)TEXT)) / 2;
            int y1 = y + (entryHeight - 9) / 2;
            context.method_27535(((ReminderListWidget)ReminderListWidget.this).field_22740.field_1772, TEXT, x1, y1, Colors.WHITE.asInt());
        }
    }

    protected class ReminderEntry
    extends Entry {
        protected Pair<Reminder, TimedObject> reminder;
        private final class_2561 name;
        private final class_2561 expireTime;
        private final class_2561 description;
        private final class_1799 icon;

        public ReminderEntry(Pair<Reminder, TimedObject> reminder) {
            this.reminder = reminder;
            this.name = ((Reminder)reminder.left()).display().title();
            Instant expiration = ((TimedObject)reminder.right()).expirationTime();
            String time = TimeUtils.formatInstant(expiration, TimeUtils.DATE_FULL);
            String relative = TimeUtils.getDurationFormatted(expiration);
            this.expireTime = class_2561.method_43470((String)"> ").method_27692(class_124.field_1068).method_10852((class_2561)class_2561.method_43470((String)time).method_27692(class_124.field_1075)).method_10852((class_2561)class_2561.method_43470((String)(" (In " + relative + ")")).method_27692(class_124.field_1080));
            this.description = ((Reminder)reminder.left()).display().description() != null ? ((Reminder)reminder.left()).display().description() : StonksUtils.jsonToText(((TimedObject)reminder.right()).message()).orElse((class_2561)class_2561.method_43470((String)((TimedObject)reminder.right()).message()));
            this.icon = ((Reminder)reminder.left()).display().icon();
        }

        public class_2561 method_37006() {
            return class_2561.method_43470((String)("Reminder " + this.name.getString()));
        }

        public void method_25343(@NotNull class_332 context, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean hovered, float tickProgress) {
            if (ReminderListWidget.this.field_22740 == null || ((ReminderListWidget)ReminderListWidget.this).field_22740.field_1755 == null || ((ReminderListWidget)ReminderListWidget.this).field_22740.field_1772 == null) {
                return;
            }
            context.method_27535(((ReminderListWidget)ReminderListWidget.this).field_22740.field_1772, this.name, x + 32 + 3, y + 1, Colors.WHITE.asInt());
            int x1 = x + 32 + 3;
            context.method_27535(((ReminderListWidget)ReminderListWidget.this).field_22740.field_1772, this.expireTime, x1, y + 12, Colors.WHITE.asInt());
            context.method_27535(((ReminderListWidget)ReminderListWidget.this).field_22740.field_1772, this.description, x1, y + 23, Colors.WHITE.asInt());
            context.method_51427(this.icon, x + 7, y + 7);
        }
    }

    protected static abstract class Entry
    extends class_4280.class_4281<Entry> {
    }
}

