/*
 * Decompiled with CFR 0.152.
 */
package fr.siroz.cariboustonks.util.colors;

import java.awt.Color;
import net.minecraft.class_124;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public final class ColorUtils {
    private ColorUtils() {
    }

    @Contract(value="_, _, _ -> new")
    @NotNull
    public static Color interpolatedColor(@NotNull Color startColor, @NotNull Color endColor, float factor) {
        factor = Math.max(0.0f, Math.min(1.0f, factor));
        int red = (int)((float)startColor.getRed() + factor * (float)(endColor.getRed() - startColor.getRed()));
        int green = (int)((float)startColor.getGreen() + factor * (float)(endColor.getGreen() - startColor.getGreen()));
        int blue = (int)((float)startColor.getBlue() + factor * (float)(endColor.getBlue() - startColor.getBlue()));
        int alpha = (int)((float)startColor.getAlpha() + factor * (float)(endColor.getAlpha() - startColor.getAlpha()));
        return new Color(red, green, blue, alpha);
    }

    public static int changeAlpha(int originalColor, int alpha) {
        int color = originalColor & 0xFFFFFF;
        return alpha << 24 | color;
    }

    @Contract(value="_ -> new", pure=true)
    public static float @NotNull [] getFloatComponents(int color) {
        return new float[]{(float)(color >> 16 & 0xFF) / 255.0f, (float)(color >> 8 & 0xFF) / 255.0f, (float)(color & 0xFF) / 255.0f};
    }

    public static int hsbToRGB(float hueComponent, float saturationColor, float brightnessColor) {
        return Color.getHSBColor(hueComponent, saturationColor, brightnessColor).getRGB();
    }

    public static Color getAwtColor(@NotNull class_124 formatting) {
        if (formatting.method_532() == null) {
            return Color.WHITE;
        }
        float[] components = ColorUtils.getFloatComponents(formatting.method_532());
        return new Color(components[0], components[1], components[2]);
    }
}

