/*
 * Decompiled with CFR 0.152.
 */
package fr.siroz.cariboustonks.util.math.bezier;

import java.util.List;
import java.util.stream.IntStream;
import net.minecraft.class_243;
import org.jetbrains.annotations.NotNull;

public class BezierCurve {
    private final List<double[]> coefficients;

    public BezierCurve(@NotNull List<double[]> coefficients) {
        if (coefficients.size() != 3) {
            throw new IllegalArgumentException();
        }
        this.coefficients = coefficients;
    }

    public class_243 getDerivative(double t) {
        double x = 0.0;
        double y = 0.0;
        double z = 0.0;
        for (int dim = 0; dim < 3; ++dim) {
            double result = 0.0;
            double[] coefficient = this.coefficients.get(dim);
            double[] reversed = this.reverseArray(coefficient);
            for (int i = 0; i < reversed.length - 1; ++i) {
                result = result * t + reversed[i] * (double)(reversed.length - 1 - i);
            }
            if (dim == 0) {
                x = result;
                continue;
            }
            if (dim == 1) {
                y = result;
                continue;
            }
            z = result;
        }
        return new class_243(x, y, z);
    }

    public class_243 getPoint(double t) {
        double x = 0.0;
        double y = 0.0;
        double z = 0.0;
        for (int dim = 0; dim < 3; ++dim) {
            double[] reversed;
            double result = 0.0;
            double[] coefficient = this.coefficients.get(dim);
            for (double value : reversed = this.reverseArray(coefficient)) {
                result = result * t + value;
            }
            if (dim == 0) {
                x = result;
                continue;
            }
            if (dim == 1) {
                y = result;
                continue;
            }
            z = result;
        }
        return new class_243(x, y, z);
    }

    private double[] reverseArray(double @NotNull [] array) {
        return IntStream.range(0, array.length).mapToDouble(i -> array[array.length - 1 - i]).toArray();
    }
}

