/*
 * Decompiled with CFR 0.152.
 */
package fr.siroz.cariboustonks.core.data.hypixel;

import fr.siroz.cariboustonks.CaribouStonks;
import fr.siroz.cariboustonks.core.data.hypixel.SkyBlockItem;
import fr.siroz.cariboustonks.core.data.mod.SkyBlockAttribute;
import fr.siroz.cariboustonks.util.Rarity;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class HypixelAPIFixer {
    public static final Pattern MINION_PATTERN = Pattern.compile("^[A-Z_]+_GENERATOR_\\d+$");
    public static final Pattern ENCHANTMENT_PATTERN = Pattern.compile("^ENCHANTMENT_[A-Z_]+_\\d+$");
    public static final Pattern ESSENCE_PATTERN = Pattern.compile("^ESSENCE_[A-Z]+$");
    public static final Pattern SHARD_PATTERN = Pattern.compile("^SHARD_[A-Z]+(_[A-Z]+)*$");

    HypixelAPIFixer() {
    }

    public boolean isBlacklisted(@NotNull String inputId) {
        boolean blacklisted = false;
        Matcher minionMatcher = MINION_PATTERN.matcher(inputId);
        if (minionMatcher.matches()) {
            return true;
        }
        return blacklisted;
    }

    public boolean isEnchantment(@NotNull String inputId) {
        Matcher matcher = ENCHANTMENT_PATTERN.matcher(inputId);
        return matcher.matches();
    }

    public boolean isEssence(@NotNull String inputId) {
        Matcher matcher = ESSENCE_PATTERN.matcher(inputId);
        return matcher.matches();
    }

    public boolean isShard(@NotNull String inputId) {
        Matcher matcher = SHARD_PATTERN.matcher(inputId);
        return matcher.matches();
    }

    @NotNull
    public SkyBlockItem createEnchant(@NotNull String skyBlockIdEnchantment) {
        String material = "ENCHANTED_BOOK";
        String name = this.getEnchantName(skyBlockIdEnchantment);
        Rarity tier = skyBlockIdEnchantment.contains("ULTIMATE") ? Rarity.MYTHIC : Rarity.UNCOMMON;
        return new SkyBlockItem(skyBlockIdEnchantment, material, name, tier);
    }

    @NotNull
    public SkyBlockItem createEssence(@NotNull String skyBlockIdEssence) {
        String material = "SKULL_ITEM";
        String name = this.getEssenceName(skyBlockIdEssence);
        return new SkyBlockItem(skyBlockIdEssence, material, name, Rarity.MYTHIC);
    }

    @Nullable
    public SkyBlockItem createShard(@NotNull String skyBlockIdShard) {
        SkyBlockAttribute attribute = CaribouStonks.core().getModDataSource().getAttributeBySkyBlockId(skyBlockIdShard);
        if (attribute != null) {
            String material = "PRISMARINE_SHARD";
            String name = attribute.name() + " (" + attribute.id() + ")";
            Rarity tier = attribute.getRarityFromId();
            return new SkyBlockItem(skyBlockIdShard, material, name, tier);
        }
        return null;
    }

    @NotNull
    public String getEnchantName(@NotNull String inputId) {
        if (inputId.isEmpty()) {
            return "";
        }
        String withoutPrefix = inputId.replaceFirst("^ENCHANTMENT_", "");
        String[] words = withoutPrefix.split("_");
        StringBuilder prettyName = new StringBuilder();
        for (int i = 0; i < words.length; ++i) {
            Object word = words[i].toLowerCase();
            word = ((String)word).substring(0, 1).toUpperCase() + ((String)word).substring(1);
            if (i > 0) {
                prettyName.append(" ");
            }
            prettyName.append((String)word);
        }
        return prettyName.toString();
    }

    @NotNull
    public String getEssenceName(@NotNull String input) {
        if (!input.contains("_")) {
            return input;
        }
        String essenceName = input.split("_")[1];
        String prettyName = essenceName.substring(0, 1).toUpperCase() + essenceName.substring(1).toLowerCase();
        return prettyName + " Essence";
    }
}

