/*
 * Decompiled with CFR 0.152.
 */
package fr.siroz.cariboustonks.core.data.item;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ItemLookupKey {
    @Nullable
    private final String neuId;
    @Nullable
    private final String hypixelSkyBlockId;

    private ItemLookupKey(@Nullable String neuId, @Nullable String hypixelSkyBlockId) {
        this.neuId = neuId;
        this.hypixelSkyBlockId = hypixelSkyBlockId;
    }

    @NotNull
    public static ItemLookupKey ofHypixelSkyBlockId(@NotNull String hypixelSkyBlockId) {
        return new ItemLookupKey(null, hypixelSkyBlockId);
    }

    @NotNull
    public static ItemLookupKey ofNeuId(@NotNull String neuId) {
        return new ItemLookupKey(neuId, null);
    }

    @NotNull
    public static ItemLookupKey of(@Nullable String neuId, @Nullable String hypixelSkyBlockId) {
        return new ItemLookupKey(neuId, hypixelSkyBlockId);
    }

    @Nullable
    public String getNeuId() {
        return this.neuId;
    }

    @Nullable
    public String getHypixelSkyBlockId() {
        return this.hypixelSkyBlockId;
    }

    public boolean isNull() {
        return this.neuId == null && this.hypixelSkyBlockId == null;
    }

    public String toString() {
        return "ItemLookupKey{neuId='" + this.neuId + "', hypixelSkyBlockId='" + this.hypixelSkyBlockId + "'}";
    }
}

