/*
 * Decompiled with CFR 0.152.
 */
package fr.siroz.cariboustonks.core.json;

import com.google.gson.Gson;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import fr.siroz.cariboustonks.core.json.adapters.ColorAdapter;
import fr.siroz.cariboustonks.core.json.adapters.InstantAdapter;
import fr.siroz.cariboustonks.core.json.adapters.PositionAdapter;
import fr.siroz.cariboustonks.core.json.adapters.TimedObjectAdapter;
import fr.siroz.cariboustonks.core.json.adapters.WaypointAdapter;
import fr.siroz.cariboustonks.manager.reminder.TimedObject;
import fr.siroz.cariboustonks.manager.waypoint.Waypoint;
import fr.siroz.cariboustonks.util.colors.Color;
import fr.siroz.cariboustonks.util.position.Position;
import java.time.Instant;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CustomTypeAdapterFactory
implements TypeAdapterFactory {
    public static final CustomTypeAdapterFactory INSTANCE = new CustomTypeAdapterFactory();
    private final Map<Class<?>, TypeAdapter<?>> adapters = new HashMap();

    private CustomTypeAdapterFactory() {
        ColorAdapter colorAdapter = new ColorAdapter();
        InstantAdapter instantAdapter = new InstantAdapter();
        PositionAdapter positionAdapter = new PositionAdapter();
        this.adapters.put(Color.class, colorAdapter);
        this.adapters.put(Instant.class, instantAdapter);
        this.adapters.put(Position.class, positionAdapter);
        this.adapters.put(TimedObject.class, new TimedObjectAdapter(instantAdapter));
        this.adapters.put(Waypoint.class, new WaypointAdapter(positionAdapter, colorAdapter));
    }

    @Nullable
    public <T> TypeAdapter<T> create(Gson gson, @NotNull TypeToken<T> type) {
        TypeAdapter<?> adapter = this.adapters.get(type.getRawType());
        return adapter != null ? adapter : null;
    }
}

