/*
 * Decompiled with CFR 0.152.
 */
package fr.siroz.cariboustonks.core.json.adapters;

import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import fr.siroz.cariboustonks.manager.reminder.TimedObject;
import java.io.IOException;
import java.lang.runtime.SwitchBootstraps;
import java.time.Instant;

public class TimedObjectAdapter
extends TypeAdapter<TimedObject> {
    private final TypeAdapter<Instant> instant;

    public TimedObjectAdapter(TypeAdapter<Instant> instantAdapter) {
        this.instant = instantAdapter;
    }

    public void write(JsonWriter writer, TimedObject timedObject) throws IOException {
        writer.beginObject();
        writer.name("id").value(timedObject.id());
        writer.name("message").value(timedObject.message());
        writer.name("expirationTime");
        this.instant.write(writer, (Object)timedObject.expirationTime());
        writer.name("type").value(timedObject.type());
        writer.endObject();
    }

    public TimedObject read(JsonReader reader) throws IOException {
        reader.beginObject();
        String id = "";
        String message = "";
        Instant expirationTime = null;
        String type = "";
        while (reader.hasNext()) {
            String string = reader.nextName();
            int n = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{"id", "message", "expirationTime", "type"}, (Object)string, n)) {
                case 0: {
                    id = reader.nextString();
                    break;
                }
                case 1: {
                    message = reader.nextString();
                    break;
                }
                case 2: {
                    expirationTime = (Instant)this.instant.read(reader);
                    break;
                }
                case 3: {
                    type = reader.nextString();
                    break;
                }
            }
        }
        reader.endObject();
        return new TimedObject(id, message, expirationTime, type);
    }
}

