/*
 * Decompiled with CFR 0.152.
 */
package fr.siroz.cariboustonks.core.json.adapters;

import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import fr.siroz.cariboustonks.core.json.GsonProvider;
import fr.siroz.cariboustonks.manager.waypoint.Waypoint;
import fr.siroz.cariboustonks.manager.waypoint.options.TextOption;
import fr.siroz.cariboustonks.util.colors.Color;
import fr.siroz.cariboustonks.util.colors.Colors;
import fr.siroz.cariboustonks.util.position.Position;
import java.io.IOException;
import java.lang.runtime.SwitchBootstraps;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.class_2561;
import org.jetbrains.annotations.NotNull;

public class WaypointAdapter
extends TypeAdapter<Waypoint> {
    private final TypeAdapter<Position> positionAdapter;
    private final TypeAdapter<Color> colorAdapter;

    public WaypointAdapter(TypeAdapter<Position> positionAdapter, TypeAdapter<Color> colorAdapter) {
        this.positionAdapter = positionAdapter;
        this.colorAdapter = colorAdapter;
    }

    public void write(@NotNull JsonWriter writer, @NotNull Waypoint waypoint) throws IOException {
        writer.beginObject();
        writer.name("uuid").value(waypoint.getUuid().toString());
        writer.name("position");
        this.positionAdapter.write(writer, (Object)waypoint.getPosition());
        writer.name("enabled").value(waypoint.isEnabled());
        writer.name("type").value(waypoint.getType().name());
        writer.name("alpha").value(waypoint.getAlpha());
        writer.name("color");
        this.colorAdapter.write(writer, (Object)waypoint.getColor());
        Optional<class_2561> text = waypoint.getTextOption().getText();
        writer.name("text").value(text.isPresent() ? GsonProvider.standard().toJson((Object)text.get()) : "");
        writer.endObject();
    }

    public Waypoint read(@NotNull JsonReader reader) throws IOException {
        reader.beginObject();
        UUID uuid = UUID.randomUUID();
        Position position = Position.ORIGIN;
        boolean enabled = false;
        Waypoint.Type type = Waypoint.Type.WAYPOINT;
        float alpha = 1.0f;
        Color color = Colors.RED;
        class_2561 text = null;
        while (reader.hasNext()) {
            String string = reader.nextName();
            int n = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{"uuid", "position", "enabled", "type", "alpha", "color", "text"}, (Object)string, n)) {
                case 0: {
                    uuid = UUID.fromString(reader.nextString());
                    break;
                }
                case 1: {
                    position = (Position)this.positionAdapter.read(reader);
                    break;
                }
                case 2: {
                    enabled = reader.nextBoolean();
                    break;
                }
                case 3: {
                    type = Waypoint.Type.valueOf(reader.nextString());
                    break;
                }
                case 4: {
                    alpha = Float.parseFloat(reader.nextString());
                    break;
                }
                case 5: {
                    color = (Color)this.colorAdapter.read(reader);
                    break;
                }
                case 6: {
                    text = (class_2561)GsonProvider.standard().fromJson(reader.nextString(), class_2561.class);
                    break;
                }
            }
        }
        reader.endObject();
        return Waypoint.builder(position).uuid(uuid).enabled(enabled).type(type).alpha(alpha).color(color).textOption(TextOption.builder().withText(text).build()).build();
    }
}

