/*
 * Decompiled with CFR 0.152.
 */
package fr.siroz.cariboustonks.core.skyblock;

import java.util.Arrays;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public enum IslandType {
    ANY("#any#", "Any"),
    PRIVATE_ISLAND("dynamic", "Private Island"),
    HUB("hub", "Hub"),
    THE_FARMING_ISLAND("farming_1", "The Farming Islands"),
    GARDEN("garden", "Garden"),
    GOLD_MINE("mining_1", "Gold Mine"),
    DEEP_CAVERNS("mining_2", "Deep Caverns"),
    DWARVEN_MINES("mining_3", "Dwarven Mines"),
    CRYSTAL_HOLLOWS("crystal_hollows", "Crystal Hollows"),
    GLACITE_MINESHAFT("mineshaft", "Mineshaft"),
    SPIDER_DEN("combat_1", "Spider's Den"),
    BLAZING_FORTRESS("combat_2", "Nether"),
    THE_END("combat_3", "The End"),
    CRIMSON_ISLE("crimson_isle", "Crimson Isle"),
    KUUDRA_HOLLOW("kuudra", "Kuudra's Hollow"),
    DUNGEON_HUB("dungeon_hub", "Dungeon Hub"),
    DUNGEON("dungeon", "Dungeons"),
    THE_PARK("foraging_1", "The Park"),
    GALATEA("foraging_2", "Galatea"),
    BACKWATER_BAYOU("fishing_1", "Backwater Bayou"),
    JERRY_WORKSHOP("winter", "Jerry's Workshop"),
    DARK_AUCTION("dark_auction", "Dark Auction"),
    THE_RIFT("rift", "The Rift"),
    UNKNOWN("unknown", "Unknown");

    public static final IslandType[] VALUES;
    private final String id;
    private final String name;

    private IslandType(String id, String name) {
        this.id = id;
        this.name = name;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return this.name;
    }

    @NotNull
    public static IslandType getById(@Nullable String id) {
        if (id == null || id.isEmpty()) {
            return UNKNOWN;
        }
        return Arrays.stream(IslandType.values()).filter(is -> id.equals(is.getId())).findFirst().orElse(UNKNOWN);
    }

    static {
        VALUES = (IslandType[])Arrays.stream(IslandType.values()).filter(is -> {
            try {
                return IslandType.class.getField(is.name()).getAnnotation(Deprecated.class) == null;
            }
            catch (NoSuchFieldException ignored) {
                return true;
            }
        }).toArray(IslandType[]::new);
    }
}

