/*
 * Decompiled with CFR 0.152.
 */
package fr.siroz.cariboustonks.event;

import net.fabricmc.fabric.api.event.Event;
import net.fabricmc.fabric.api.event.EventFactory;
import net.minecraft.class_1531;
import net.minecraft.class_2675;
import net.minecraft.class_2767;
import org.jetbrains.annotations.NotNull;

public final class NetworkEvents {
    public static final Event<GameJoin> GAME_JOIN_PACKET = EventFactory.createArrayBacked(GameJoin.class, listeners -> () -> {
        for (GameJoin listener : listeners) {
            listener.onGameJoin();
        }
    });
    public static final Event<WorldTimeUpdate> WORLD_TIME_UPDATE_PACKET = EventFactory.createArrayBacked(WorldTimeUpdate.class, listeners -> () -> {
        for (WorldTimeUpdate listener : listeners) {
            listener.onWorldTimeUpdate();
        }
    });
    public static final Event<PingResult> PING_RESULT = EventFactory.createArrayBacked(PingResult.class, listeners -> ping -> {
        for (PingResult listener : listeners) {
            listener.onPingResult(ping);
        }
    });
    public static final Event<ParticlePreReceived> PARTICLE_PRE_RECEIVED_PACKET = EventFactory.createArrayBacked(ParticlePreReceived.class, listeners -> particlePacket -> {
        for (ParticlePreReceived listener : listeners) {
            if (!listener.onParticlePreReceived(particlePacket)) continue;
            return true;
        }
        return false;
    });
    public static final Event<ParticleReceived> PARTICLE_RECEIVED_PACKET = EventFactory.createArrayBacked(ParticleReceived.class, listeners -> particlePacket -> {
        for (ParticleReceived listener : listeners) {
            listener.onParticleReceived(particlePacket);
        }
    });
    public static final Event<PlaySound> PLAY_SOUND_PACKET = EventFactory.createArrayBacked(PlaySound.class, listeners -> soundPacket -> {
        for (PlaySound listener : listeners) {
            listener.onPlaySound(soundPacket);
        }
    });
    public static final Event<ArmorStandUpdate> ARMORSTAND_UPDATE_PACKET = EventFactory.createArrayBacked(ArmorStandUpdate.class, listeners -> (entity, equipmentUpdate) -> {
        for (ArmorStandUpdate listener : listeners) {
            listener.onArmorStandUpdate(entity, equipmentUpdate);
        }
    });

    private NetworkEvents() {
    }

    @FunctionalInterface
    public static interface ArmorStandUpdate {
        public void onArmorStandUpdate(@NotNull class_1531 var1, boolean var2);
    }

    @FunctionalInterface
    public static interface PlaySound {
        public void onPlaySound(class_2767 var1);
    }

    @FunctionalInterface
    public static interface ParticleReceived {
        public void onParticleReceived(class_2675 var1);
    }

    @FunctionalInterface
    public static interface ParticlePreReceived {
        public boolean onParticlePreReceived(class_2675 var1);
    }

    @FunctionalInterface
    public static interface PingResult {
        public void onPingResult(long var1);
    }

    @FunctionalInterface
    public static interface WorldTimeUpdate {
        public void onWorldTimeUpdate();
    }

    @FunctionalInterface
    public static interface GameJoin {
        public void onGameJoin();
    }
}

