/*
 * Decompiled with CFR 0.152.
 */
package fr.siroz.cariboustonks.feature.chat;

import fr.siroz.cariboustonks.config.ConfigManager;
import fr.siroz.cariboustonks.config.configs.ChatConfig;
import fr.siroz.cariboustonks.core.skyblock.SkyBlockAPI;
import fr.siroz.cariboustonks.event.ChatEvents;
import fr.siroz.cariboustonks.feature.Feature;
import fr.siroz.cariboustonks.mixin.accessors.MessageHandlerAccessor;
import fr.siroz.cariboustonks.util.StonksUtils;
import java.time.Instant;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_5250;

public class ChatColorationFeature
extends Feature {
    private static final Pattern GUILD_JOIN_LEAVE_PATTERN = Pattern.compile("^Guild > [^ ]+ (joined|left)\\.$");

    public ChatColorationFeature() {
        ChatEvents.MESSAGE_RECEIVED.register(this::onMessage);
    }

    @Override
    public boolean isEnabled() {
        return SkyBlockAPI.isOnSkyBlock();
    }

    private void onMessage(class_2561 message) {
        if (!this.isEnabled()) {
            return;
        }
        String plain = StonksUtils.stripColor(message.getString());
        if (plain.startsWith("Party >")) {
            ChatConfig.ChatParty config = ConfigManager.getConfig().chat.chatParty;
            if (!config.chatPartyColored) {
                return;
            }
            class_5250 newText = message.method_27661();
            ((class_5250)newText.method_10855().getLast()).method_54663(config.chatPartyColor.getRGB());
            this.sendMessageToBypassEvents((class_2561)newText);
        } else if (plain.startsWith("Guild >")) {
            ChatConfig.ChatGuild config = ConfigManager.getConfig().chat.chatGuild;
            if (!config.chatGuildColored) {
                return;
            }
            Matcher guildJoinLeaveMatcher = GUILD_JOIN_LEAVE_PATTERN.matcher(plain);
            if (guildJoinLeaveMatcher.matches()) {
                return;
            }
            class_5250 newText = message.method_27661();
            ((class_5250)newText.method_10855().getLast()).method_54663(config.chatGuildColor.getRGB());
            this.sendMessageToBypassEvents((class_2561)newText);
        }
    }

    private void sendMessageToBypassEvents(class_2561 message) {
        class_310 client = class_310.method_1551();
        ((MessageHandlerAccessor)client.method_44714()).invokeAddToChatLog(message, Instant.now());
        client.method_44713().method_47976(message);
    }
}

