/*
 * Decompiled with CFR 0.152.
 */
package fr.siroz.cariboustonks.feature.chat;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import fr.siroz.cariboustonks.CaribouStonks;
import fr.siroz.cariboustonks.config.ConfigManager;
import fr.siroz.cariboustonks.config.configs.UIAndVisualsConfig;
import fr.siroz.cariboustonks.core.skyblock.SkyBlockAPI;
import fr.siroz.cariboustonks.event.ChatEvents;
import fr.siroz.cariboustonks.feature.Feature;
import fr.siroz.cariboustonks.feature.diana.MythologicalRitualFeature;
import fr.siroz.cariboustonks.manager.command.CommandRegistration;
import fr.siroz.cariboustonks.manager.waypoint.Waypoint;
import fr.siroz.cariboustonks.manager.waypoint.options.TextOption;
import fr.siroz.cariboustonks.util.Client;
import fr.siroz.cariboustonks.util.colors.Color;
import fr.siroz.cariboustonks.util.colors.Colors;
import fr.siroz.cariboustonks.util.cooldown.Cooldown;
import fr.siroz.cariboustonks.util.position.Position;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandManager;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_5250;
import net.minecraft.class_7157;
import org.jetbrains.annotations.NotNull;

public class ChatPositionFeature
extends Feature
implements CommandRegistration {
    private static final Pattern SIMPLE_COORDS_PATTERN = Pattern.compile("(?<playerName>.*): (?<x>-?[0-9]+) (?<y>[0-9]+) (?<z>-?[0-9]+)");
    private static final Pattern SIMPLE_COMMA_COORDS_PATTERN = Pattern.compile("(?<playerName>.*): (?<x>-?[0-9]+), (?<y>[0-9]+), (?<z>-?[0-9]+)");
    private static final Pattern GENERIC_POSITION_PATTERN = Pattern.compile("(?<playerName>.*): x: (?<x>-?[0-9]+), y: (?<y>[0-9]+), z: (?<z>-?[0-9]+)");
    private static final List<Pattern> PATTERNS = List.of(SIMPLE_COORDS_PATTERN, SIMPLE_COMMA_COORDS_PATTERN, GENERIC_POSITION_PATTERN);
    private static final Cooldown COOLDOWN = Cooldown.of(10L, TimeUnit.SECONDS);

    public ChatPositionFeature() {
        ChatEvents.MESSAGE_RECEIVED.register(this::onMessage);
    }

    @Override
    public boolean isEnabled() {
        return SkyBlockAPI.isOnSkyBlock() && ConfigManager.getConfig().uiAndVisuals.sharedPositionWaypoint.enabled;
    }

    @Override
    public void register(@NotNull CommandDispatcher<FabricClientCommandSource> dispatcher, @NotNull class_7157 _ra) {
        dispatcher.register((LiteralArgumentBuilder)ClientCommandManager.literal((String)"cariboustonks").then(ClientCommandManager.literal((String)"sharePosition").executes(context -> this.shareCurrentPosition((FabricClientCommandSource)context.getSource()))));
        dispatcher.register((LiteralArgumentBuilder)ClientCommandManager.literal((String)"sendCoords").executes(context -> this.shareCurrentPosition((FabricClientCommandSource)context.getSource())));
    }

    private void onMessage(class_2561 text) {
        if (!this.isEnabled()) {
            return;
        }
        String message = text.getString();
        if (message.startsWith("[CaribouStonks]")) {
            return;
        }
        for (Pattern pattern : PATTERNS) {
            Matcher matcher = pattern.matcher(message);
            if (!matcher.find()) continue;
            try {
                String playerNameRaw = matcher.namedGroups().containsKey("playerName") ? matcher.group("playerName") : "";
                String playerName = playerNameRaw.isEmpty() ? "" : playerNameRaw.substring(playerNameRaw.lastIndexOf(32) + 1);
                String x = matcher.group("x");
                String y = matcher.group("y");
                String z = matcher.group("z");
                this.createWaypoint(playerName, x, y, z);
            }
            catch (Exception ex) {
                CaribouStonks.LOGGER.error("[ChatPositionFeature] Unable to parse a chat waypoint", (Throwable)ex);
            }
            break;
        }
    }

    private int shareCurrentPosition(@NotNull FabricClientCommandSource source) {
        if (COOLDOWN.test()) {
            Position position = Position.of(source.getPosition());
            Object area = "";
            if (ConfigManager.getConfig().uiAndVisuals.sharedPositionWaypoint.shareWithArea) {
                area = " | " + SkyBlockAPI.getArea().orElse("");
            }
            String message = position.asChatCoordinates() + (String)area;
            Client.sendChatMessage(message);
        } else {
            source.sendFeedback((class_2561)CaribouStonks.prefix().get().method_10852((class_2561)class_2561.method_43470((String)"Command on cooldown!").method_27692(class_124.field_1061)));
        }
        return 1;
    }

    private void createWaypoint(String playerName, String x, String y, String z) {
        if (x.isEmpty() && y.isEmpty() && z.isEmpty()) {
            return;
        }
        try {
            int positionX = Integer.parseInt(x);
            int positionY = Integer.parseInt(y);
            int positionZ = Integer.parseInt(z);
            Position position = Position.of(positionX, positionY, positionZ);
            UIAndVisualsConfig.SharedPositionWaypoint config = ConfigManager.getConfig().uiAndVisuals.sharedPositionWaypoint;
            int showTime = config.showTime;
            Color color = config.rainbow ? Colors.RAINBOW : Color.fromInt(config.color.getRGB());
            class_5250 waypointName = playerName.isEmpty() ? class_2561.method_43470((String)"- ? -").method_27695(new class_124[]{class_124.field_1054, class_124.field_1067}) : class_2561.method_43470((String)playerName).method_27692(class_124.field_1075);
            Waypoint.builder(position).color(color).timeout(showTime, TimeUnit.SECONDS).resetBetweenWorlds(true).textOption(TextOption.builder().withText((class_2561)waypointName).withDistance(true).build()).buildAndRegister();
            CaribouStonks.features().getFeature(MythologicalRitualFeature.class).onPlayerFoundInquisitor(playerName);
        }
        catch (Exception ex) {
            CaribouStonks.LOGGER.error("[ChatPositionFeature] Unable to create waypoint", (Throwable)ex);
        }
    }
}

