/*
 * Decompiled with CFR 0.152.
 */
package fr.siroz.cariboustonks.feature.combat;

import fr.siroz.cariboustonks.config.ConfigManager;
import fr.siroz.cariboustonks.core.skyblock.IslandType;
import fr.siroz.cariboustonks.core.skyblock.SkyBlockAPI;
import fr.siroz.cariboustonks.feature.Feature;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.message.v1.ClientReceiveMessageEvents;
import net.minecraft.class_2561;
import net.minecraft.class_2784;
import net.minecraft.class_310;
import org.jetbrains.annotations.NotNull;

public class LowHealthWarningFeature
extends Feature {
    private static final class_310 CLIENT = class_310.method_1551();
    private static final Pattern HEALTH_ACTION_BAR_PATTERN = Pattern.compile("\u00a7[6c](?<health>[\\d,]+)/(?<max>[\\d,]+)\u2764 *(?<healing>\\+\u00a7c([\\d,]+). *)?");
    private Health currentHealth = Health.DEFAULT;
    private boolean triggered = false;

    public LowHealthWarningFeature() {
        ClientReceiveMessageEvents.ALLOW_GAME.register(this::allowActionBar);
        ClientTickEvents.END_CLIENT_TICK.register(client -> this.onTick());
    }

    @Override
    public boolean isEnabled() {
        return SkyBlockAPI.isOnSkyBlock() && SkyBlockAPI.getIsland() != IslandType.THE_RIFT && ConfigManager.getConfig().combat.lowHealthWarning.lowHealthWarningEnabled;
    }

    private boolean allowActionBar(class_2561 text, boolean overlay) {
        Matcher healthActionBarMatcher;
        if (overlay && this.isEnabled() && (healthActionBarMatcher = HEALTH_ACTION_BAR_PATTERN.matcher(text.getString())).find()) {
            this.updateHealth(healthActionBarMatcher);
        }
        return true;
    }

    private void onTick() {
        if (!this.isEnabled() || LowHealthWarningFeature.CLIENT.field_1724 == null || LowHealthWarningFeature.CLIENT.field_1687 == null) {
            return;
        }
        this.updateHealth(this.currentHealth.value, this.currentHealth.max, this.currentHealth.overflow);
    }

    private void updateHealth(@NotNull Matcher matcher) {
        try {
            int health = Integer.parseInt(matcher.group("health").replace(",", ""));
            int max = Integer.parseInt(matcher.group("max").replace(",", ""));
            this.updateHealth(health, max, Math.max(0, health - max));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void updateHealth(int value, int max, int overflow) {
        if (LowHealthWarningFeature.CLIENT.field_1724 != null) {
            value = (int)(LowHealthWarningFeature.CLIENT.field_1724.method_6032() * (float)max / LowHealthWarningFeature.CLIENT.field_1724.method_6063());
            overflow = (int)(LowHealthWarningFeature.CLIENT.field_1724.method_6067() * (float)max / LowHealthWarningFeature.CLIENT.field_1724.method_6063());
        }
        this.currentHealth = new Health(Math.min(value, max), max, Math.min(overflow, max));
        this.lowHealthCheck();
    }

    private void lowHealthCheck() {
        try {
            int configThreshold = ConfigManager.getConfig().combat.lowHealthWarning.lowHealthWarningThreshold;
            int threshold = (int)((double)this.currentHealth.max * ((double)configThreshold / 100.0));
            if (this.currentHealth.value <= threshold) {
                this.triggerLowHealthWarning();
            } else {
                if (this.triggered) {
                    this.remove();
                }
                this.triggered = false;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void triggerLowHealthWarning() {
        if (this.triggered) {
            return;
        }
        this.triggered = true;
        this.show();
    }

    private void show() {
        if (LowHealthWarningFeature.CLIENT.field_1724 == null) {
            return;
        }
        class_2784 worldBorder = LowHealthWarningFeature.CLIENT.field_1724.method_37908().method_8621();
        worldBorder.method_11969(1.0);
        worldBorder.method_11978(LowHealthWarningFeature.CLIENT.field_1724.method_23317() + 5555.0, LowHealthWarningFeature.CLIENT.field_1724.method_23321() + 5555.0);
    }

    private void remove() {
        if (LowHealthWarningFeature.CLIENT.field_1724 == null) {
            return;
        }
        LowHealthWarningFeature.CLIENT.field_1724.method_37908().method_8621().method_17905(class_2784.field_24122);
    }

    private record Health(int value, int max, int overflow) {
        public static final Health DEFAULT = new Health(100, 100, 0);
    }
}

