/*
 * Decompiled with CFR 0.152.
 */
package fr.siroz.cariboustonks.feature.diana;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import fr.siroz.cariboustonks.event.NetworkEvents;
import fr.siroz.cariboustonks.feature.diana.GriffinBurrow;
import fr.siroz.cariboustonks.feature.diana.MythologicalRitualFeature;
import fr.siroz.cariboustonks.util.ItemUtils;
import java.lang.runtime.SwitchBootstraps;
import java.time.Duration;
import java.util.HashMap;
import java.util.Map;
import net.fabricmc.fabric.api.event.player.AttackBlockCallback;
import net.fabricmc.fabric.api.event.player.UseBlockCallback;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2396;
import net.minecraft.class_2398;
import net.minecraft.class_2675;
import net.minecraft.class_310;
import net.minecraft.class_3965;
import net.minecraft.class_9322;

final class GriffinBurrowParticleFinder {
    private static final class_310 CLIENT = class_310.method_1551();
    private static final Cache<class_2338, class_2338> DUG_BURROWS_CACHE = CacheBuilder.newBuilder().expireAfterWrite(Duration.ofMinutes(1L)).build();
    private final MythologicalRitualFeature mythologicalRitual;
    private final Map<class_2338, GriffinBurrow> burrows = new HashMap<class_2338, GriffinBurrow>();
    private class_2338 lastDugParticleBurrow = null;

    GriffinBurrowParticleFinder(MythologicalRitualFeature mythologicalRitual) {
        this.mythologicalRitual = mythologicalRitual;
        AttackBlockCallback.EVENT.register(this::onAttackBlock);
        UseBlockCallback.EVENT.register(this::onUseBlock);
        NetworkEvents.PARTICLE_RECEIVED_PACKET.register(this::onParticleReceived);
    }

    public void onWorldChange() {
        this.burrows.clear();
        DUG_BURROWS_CACHE.invalidateAll();
        this.lastDugParticleBurrow = null;
    }

    private class_1269 onAttackBlock(class_1657 player, class_1937 world, class_1268 hand, class_2338 pos, class_2350 direction) {
        return this.onInteractBlock(player, hand, pos);
    }

    private class_1269 onUseBlock(class_1657 player, class_1937 world, class_1268 hand, class_3965 hitResult) {
        return this.onInteractBlock(player, hand, hitResult.method_17777());
    }

    private class_1269 onInteractBlock(class_1657 player, class_1268 hand, class_2338 pos) {
        if (this.mythologicalRitual.isEnabled() && this.mythologicalRitual.isParticleFinderEnabled() && GriffinBurrowParticleFinder.CLIENT.field_1687 != null && GriffinBurrowParticleFinder.CLIENT.field_1687.method_8320(pos).method_27852(class_2246.field_10219)) {
            this.handleInteractBlock(player, hand, pos);
        }
        return class_1269.field_5811;
    }

    private void onParticleReceived(class_2675 particle) {
        if (!this.mythologicalRitual.isEnabled() || !this.mythologicalRitual.isParticleFinderEnabled()) {
            return;
        }
        class_2338 position = class_2338.method_49637((double)particle.method_11544(), (double)particle.method_11547(), (double)particle.method_11546()).method_10074();
        if (GriffinBurrowParticleFinder.CLIENT.field_1687 == null || !GriffinBurrowParticleFinder.CLIENT.field_1687.method_8320(position).method_27852(class_2246.field_10219)) {
            return;
        }
        if (DUG_BURROWS_CACHE.getIfPresent((Object)position) != null) {
            return;
        }
        GriffinBurrow burrow = this.burrows.computeIfAbsent(position, GriffinBurrow::new);
        int count = particle.method_11545();
        float speed = particle.method_11543();
        float offsetX = particle.method_11548();
        float offsetY = particle.method_11549();
        float offsetZ = particle.method_11550();
        class_2396 class_23962 = particle.method_11551().method_10295();
        int n = 0;
        block6: while (true) {
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{class_2396.class, class_2396.class, class_2396.class, class_2396.class}, (Object)class_23962, n)) {
                case 0: {
                    class_2396 type = class_23962;
                    if (!class_2398.field_11208.equals(type)) {
                        n = 1;
                        continue block6;
                    }
                    ++burrow.critMagicParticle;
                    break block6;
                }
                case 1: {
                    class_2396 type = class_23962;
                    if (!class_2398.field_11205.equals(type)) {
                        n = 2;
                        continue block6;
                    }
                    ++burrow.critParticle;
                    break block6;
                }
                case 2: {
                    class_2396 type = class_23962;
                    if (!class_2398.field_11223.equals(type) || count != 2 || speed != 0.01f || offsetX != 0.35f || offsetY != 0.1f || offsetZ != 0.35f) {
                        n = 3;
                        continue block6;
                    }
                    burrow.setType(2);
                    break block6;
                }
                case 3: {
                    class_2396 type = class_23962;
                    if (!class_2398.field_11215.equals(type)) {
                        n = 4;
                        continue block6;
                    }
                    ++burrow.enchantParticle;
                    break block6;
                }
            }
            break;
        }
        if (burrow.critMagicParticle >= 5 && burrow.enchantParticle >= 5) {
            if (!burrow.isFound()) {
                burrow.setFound(true);
                burrow.setType(0);
                this.mythologicalRitual.onBurrowDetected(burrow);
            }
        } else if (burrow.getType() == 2) {
            if (!burrow.isFound()) {
                burrow.setFound(true);
                this.mythologicalRitual.onBurrowDetected(burrow);
            }
        } else if (burrow.critMagicParticle == 0 && burrow.critParticle >= 5 && burrow.enchantParticle >= 5 && !burrow.isFound()) {
            burrow.setFound(true);
            burrow.setType(1);
            this.mythologicalRitual.onBurrowDetected(burrow);
        }
    }

    public void onChatMessage() {
        if (!this.mythologicalRitual.isParticleFinderEnabled()) {
            return;
        }
        if (this.lastDugParticleBurrow != null) {
            this.burrows.remove(this.lastDugParticleBurrow);
            DUG_BURROWS_CACHE.put((Object)this.lastDugParticleBurrow, (Object)this.lastDugParticleBurrow);
            this.mythologicalRitual.onBurrowDug(this.lastDugParticleBurrow);
            this.lastDugParticleBurrow = null;
        }
    }

    public void handleInteractBlock(class_1657 player, class_1268 hand, class_2338 pos) {
        class_1799 stack = player.method_5998(hand);
        if (!ItemUtils.getSkyBlockItemId((class_9322)stack).equals("ANCESTRAL_SPADE")) {
            return;
        }
        if (this.burrows.containsKey(pos)) {
            this.lastDugParticleBurrow = pos;
        }
    }
}

