/*
 * Decompiled with CFR 0.152.
 */
package fr.siroz.cariboustonks.feature.diana;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import fr.siroz.cariboustonks.CaribouStonks;
import fr.siroz.cariboustonks.config.ConfigManager;
import fr.siroz.cariboustonks.core.skyblock.IslandType;
import fr.siroz.cariboustonks.core.skyblock.SkyBlockAPI;
import fr.siroz.cariboustonks.event.ChatEvents;
import fr.siroz.cariboustonks.feature.Feature;
import fr.siroz.cariboustonks.feature.diana.GriffinBurrow;
import fr.siroz.cariboustonks.feature.diana.GriffinBurrowParticleFinder;
import fr.siroz.cariboustonks.feature.diana.GuessBurrow;
import fr.siroz.cariboustonks.feature.diana.NearestWarp;
import fr.siroz.cariboustonks.manager.command.CommandRegistration;
import fr.siroz.cariboustonks.manager.keybinds.KeyBind;
import fr.siroz.cariboustonks.manager.keybinds.KeyBindRegistration;
import fr.siroz.cariboustonks.manager.waypoint.Waypoint;
import fr.siroz.cariboustonks.manager.waypoint.options.TextOption;
import fr.siroz.cariboustonks.util.Client;
import fr.siroz.cariboustonks.util.colors.Color;
import fr.siroz.cariboustonks.util.colors.Colors;
import fr.siroz.cariboustonks.util.position.Position;
import fr.siroz.cariboustonks.util.render.WorldRenderUtils;
import fr.siroz.cariboustonks.util.render.WorldRendererProvider;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandManager;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientWorldEvents;
import net.fabricmc.fabric.api.client.message.v1.ClientReceiveMessageEvents;
import net.fabricmc.fabric.api.client.rendering.v1.WorldRenderContext;
import net.fabricmc.fabric.api.client.rendering.v1.WorldRenderEvents;
import net.minecraft.class_124;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_3417;
import net.minecraft.class_7157;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Experimental
public final class MythologicalRitualFeature
extends Feature
implements KeyBindRegistration,
CommandRegistration,
WorldRendererProvider {
    static final class_310 CLIENT = class_310.method_1551();
    private static final Pattern GRIFFIN_BURROW_DUG = Pattern.compile("(?<message>You dug out a Griffin Burrow!|You finished the Griffin burrow chain!) \\((?<index>\\d)/4\\)");
    private static final Pattern INQUISITOR_FOUND_PATTERN = Pattern.compile(".* You dug out a Minos Inquisitor!");
    private final GriffinBurrowParticleFinder particleFinder;
    private final GuessBurrow guessBurrow;
    private final NearestWarp nearestWarp;
    private final Map<class_2338, Waypoint> burrows = new HashMap<class_2338, Waypoint>();
    private Waypoint guessWaypoint;
    private boolean onDiana = false;

    public MythologicalRitualFeature() {
        this.particleFinder = new GriffinBurrowParticleFinder(this);
        this.guessBurrow = new GuessBurrow(this);
        this.nearestWarp = new NearestWarp();
        ChatEvents.MESSAGE_RECEIVED.register(this::onMessage);
        ClientReceiveMessageEvents.GAME.register(this::onChatMessage);
        ClientWorldEvents.AFTER_CLIENT_WORLD_CHANGE.register((client, world) -> this.onWorldChange());
        WorldRenderEvents.AFTER_TRANSLUCENT.register(this::render);
    }

    @Override
    public boolean isEnabled() {
        return SkyBlockAPI.isOnSkyBlock() && SkyBlockAPI.getIsland() == IslandType.HUB && ConfigManager.getConfig().events.mythologicalRitual.enabled && MythologicalRitualFeature.CLIENT.field_1687 != null && MythologicalRitualFeature.CLIENT.field_1724 != null;
    }

    public void onPlayerFoundInquisitor(@Nullable String playerName) {
        if (!this.isEnabled() || !this.onDiana) {
            return;
        }
        if (playerName != null && !playerName.contains(CLIENT.method_1548().method_1676())) {
            Client.sendMessageWithPrefix((class_2561)class_2561.method_43470((String)playerName).method_27695(new class_124[]{class_124.field_1054, class_124.field_1067}).method_10852((class_2561)class_2561.method_43470((String)" found an Inquisitor!").method_27695(new class_124[]{class_124.field_1060, class_124.field_1067})));
            Client.playSound(class_3417.field_14588, 1.0f, 1.0f);
        }
    }

    @Override
    @NotNull
    public List<KeyBind> registerKeyBinds() {
        return List.of(new KeyBind("Warp Diana", 70, true, this.nearestWarp::warpToNearestWarp));
    }

    @Override
    public void register(@NotNull CommandDispatcher<FabricClientCommandSource> dispatcher, @NotNull class_7157 registryAccess) {
        dispatcher.register((LiteralArgumentBuilder)ClientCommandManager.literal((String)"cariboustonks").then(ClientCommandManager.literal((String)"resetDiana").executes(context -> {
            this.onWorldChange();
            ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)CaribouStonks.prefix().get().method_10852((class_2561)class_2561.method_43470((String)"Diana reset success.").method_27692(class_124.field_1060)));
            return 1;
        })));
    }

    @Override
    public void render(WorldRenderContext context) {
        if (this.isGuessEnabled() && this.guessWaypoint != null) {
            this.guessWaypoint.getRenderer().render(context);
        }
        if (this.isParticleFinderEnabled()) {
            for (Waypoint waypoint2 : this.burrows.values()) {
                waypoint2.getRenderer().render(context);
            }
        }
        if (!ConfigManager.getConfig().events.mythologicalRitual.lineToClosestBurrow) {
            return;
        }
        if (this.guessWaypoint != null && this.burrows.isEmpty()) {
            WorldRenderUtils.renderLineFromCursor(context, this.guessWaypoint.getPosition().toVec3d(), Colors.YELLOW, 1.0f);
        } else if (!this.burrows.isEmpty() && class_310.method_1551().field_1724 != null) {
            Waypoint waypoint3;
            class_243 closest = null;
            double minDistanceSquared = Double.MAX_VALUE;
            List<class_243> positions = this.burrows.values().stream().map(waypoint -> waypoint.getPosition().toVec3d()).toList();
            for (class_243 pos : positions) {
                double distanceSquared = class_310.method_1551().field_1724.method_19538().method_1025(pos);
                if (!(distanceSquared < minDistanceSquared)) continue;
                minDistanceSquared = distanceSquared;
                closest = pos;
            }
            if (closest != null && minDistanceSquared < 25600.0 && (waypoint3 = this.burrows.get(new class_2338((int)closest.field_1352, (int)closest.field_1351, (int)closest.field_1350))) != null) {
                WorldRenderUtils.renderLineFromCursor(context, closest.method_1031(0.5, 0.5, 0.5), waypoint3.getColor(), 1.0f);
            }
        }
    }

    private void onWorldChange() {
        this.guessBurrow.reset();
        this.onDiana = false;
        this.guessWaypoint = null;
        this.burrows.clear();
        this.particleFinder.onWorldChange();
        this.nearestWarp.reset();
    }

    private void onMessage(@NotNull class_2561 text) {
        if (!this.isEnabled()) {
            return;
        }
        if (INQUISITOR_FOUND_PATTERN.matcher(text.getString()).matches() && MythologicalRitualFeature.CLIENT.field_1724 != null) {
            Client.sendMessageWithPrefix((class_2561)class_2561.method_43470((String)"You found an Inquisitor!").method_27695(new class_124[]{class_124.field_1060, class_124.field_1067}));
            Client.showTitle((class_2561)class_2561.method_43470((String)"/K").method_27695(new class_124[]{class_124.field_1079, class_124.field_1051}).method_10852((class_2561)class_2561.method_43470((String)" INQUISITOR ").method_27692(class_124.field_1061)).method_10852((class_2561)class_2561.method_43470((String)"/K").method_27695(new class_124[]{class_124.field_1079, class_124.field_1051})), 1, 80, 20);
            Client.playSound(class_3417.field_14792, 0.8f, 1.5f);
            if (ConfigManager.getConfig().events.mythologicalRitual.shareInquisitor) {
                Position position = Position.of(MythologicalRitualFeature.CLIENT.field_1724.method_19538());
                Client.sendChatMessage("/pc " + position.asChatCoordinates());
            }
        }
    }

    private void onChatMessage(class_2561 text, boolean overlay) {
        if (!this.isEnabled()) {
            return;
        }
        if (GRIFFIN_BURROW_DUG.matcher(text.getString()).matches()) {
            this.onDiana = true;
            this.particleFinder.onChatMessage();
        }
    }

    boolean isGuessEnabled() {
        return ConfigManager.getConfig().events.mythologicalRitual.guessBurrow;
    }

    boolean isParticleFinderEnabled() {
        return ConfigManager.getConfig().events.mythologicalRitual.burrowParticleFinder;
    }

    void onBurrowGuess(class_243 location) {
        if (location == null) {
            return;
        }
        Position position = Position.of((int)location.method_10216(), (int)location.method_10214(), (int)location.method_10215());
        this.guessWaypoint = Waypoint.builder(position).textOption(TextOption.builder().withText((class_2561)class_2561.method_43470((String)"Guess").method_27695(new class_124[]{class_124.field_1054, class_124.field_1067, class_124.field_1056})).withDistance(true).withOffsetY(3).build()).color(Color.fromInt(ConfigManager.getConfig().events.mythologicalRitual.guessBurrowColor.getRGB())).build();
        if (ConfigManager.getConfig().events.mythologicalRitual.nearestWarp) {
            this.nearestWarp.shouldUseNearestWarp(position.toVec3d());
        }
    }

    void onBurrowDetected(GriffinBurrow burrow) {
        Waypoint waypoint;
        if (burrow == null) {
            return;
        }
        if (this.burrows.containsKey(burrow.getPos())) {
            return;
        }
        Position position = Position.of(burrow.getPos());
        switch (burrow.getBurrowType()) {
            default: {
                throw new MatchException(null, null);
            }
            case START: {
                Waypoint waypoint2 = Waypoint.builder(Position.of(position)).textOption(TextOption.builder().withText((class_2561)class_2561.method_43470((String)"Start").method_27695(new class_124[]{class_124.field_1060, class_124.field_1067})).withOffsetY(3).build()).color(Colors.GREEN).build();
                break;
            }
            case TREASURE: {
                Waypoint waypoint2 = Waypoint.builder(Position.of(position)).textOption(TextOption.builder().withText((class_2561)class_2561.method_43470((String)"Treasure").method_27695(new class_124[]{class_124.field_1065, class_124.field_1067})).withOffsetY(3).build()).color(Colors.ORANGE).build();
                break;
            }
            case MOB: {
                Waypoint waypoint2 = Waypoint.builder(Position.of(position)).textOption(TextOption.builder().withText((class_2561)class_2561.method_43470((String)"Mob").method_27695(new class_124[]{class_124.field_1061, class_124.field_1067})).withOffsetY(3).build()).color(Colors.RED).build();
                break;
            }
            case UNKNOWN: {
                Waypoint waypoint2 = waypoint = null;
            }
        }
        if (waypoint != null) {
            if (MythologicalRitualFeature.CLIENT.field_1724 != null) {
                MythologicalRitualFeature.CLIENT.field_1724.method_5783(class_3417.field_14627, 0.8f, 1.0f);
            }
            this.burrows.putIfAbsent(burrow.getPos(), waypoint);
        }
    }

    void onBurrowDug(class_2338 pos) {
        this.burrows.remove(pos);
        this.burrows.remove(new class_2338(pos.method_10263(), pos.method_10264() + 1, pos.method_10260()));
        this.burrows.remove(new class_2338(pos.method_10263(), pos.method_10264() - 1, pos.method_10260()));
    }
}

