/*
 * Decompiled with CFR 0.152.
 */
package fr.siroz.cariboustonks.feature.foraging;

import fr.siroz.cariboustonks.config.ConfigManager;
import fr.siroz.cariboustonks.core.scheduler.TickScheduler;
import fr.siroz.cariboustonks.core.skyblock.IslandType;
import fr.siroz.cariboustonks.core.skyblock.SkyBlockAPI;
import fr.siroz.cariboustonks.event.NetworkEvents;
import fr.siroz.cariboustonks.event.WorldEvents;
import fr.siroz.cariboustonks.feature.Feature;
import fr.siroz.cariboustonks.util.Client;
import fr.siroz.cariboustonks.util.ItemUtils;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import net.minecraft.class_1297;
import net.minecraft.class_1531;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_9322;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TreeOverlayFeature
extends Feature {
    private static final class_310 CLIENT = class_310.method_1551();
    private static final int DISTANCE_TO_TREE_INFO_IN_BLOCKS = 10;
    private static final Set<String> AXES = Set.of("ROOKIE_AXE", "SWEET_AXE", "PROMISING_AXE", "EFFICIENT_AXE", "JUNGLE_AXE", "TREECAPITATOR_AXE", "FIG_AXE", "FIGSTONE_AXE");
    private class_1531 currentTreeInfo = null;
    private class_2561 currentInfo = null;

    public TreeOverlayFeature() {
        WorldEvents.JOIN.register(world -> this.reset());
        TickScheduler.getInstance().runRepeating(this::update, 1, TimeUnit.SECONDS);
        NetworkEvents.ARMORSTAND_UPDATE_PACKET.register(this::onArmorstandUpdate);
    }

    @Override
    public boolean isEnabled() {
        return SkyBlockAPI.isOnSkyBlock() && SkyBlockAPI.getIsland() == IslandType.GALATEA && ConfigManager.getConfig().foraging.showTreeOverlayInfo;
    }

    private void update() {
        if (TreeOverlayFeature.CLIENT.field_1724 == null || TreeOverlayFeature.CLIENT.field_1687 == null) {
            return;
        }
        if (!this.isEnabled()) {
            return;
        }
        class_1799 heldItem = TreeOverlayFeature.CLIENT.field_1724.method_6047();
        String itemId = ItemUtils.getSkyBlockItemId((class_9322)heldItem);
        if (!AXES.contains(itemId)) {
            return;
        }
        if (this.currentTreeInfo == null) {
            this.currentTreeInfo = this.findClosestTreeInfoInRange((class_1297)TreeOverlayFeature.CLIENT.field_1724).orElse(null);
        } else {
            Optional<class_1531> newTreeInfo = this.findClosestTreeInfoInRange((class_1297)TreeOverlayFeature.CLIENT.field_1724);
            if (newTreeInfo.isEmpty()) {
                this.reset();
            }
        }
        if (this.currentInfo != null) {
            Client.showSubtitle(this.currentInfo, 0, 60, 20);
        }
    }

    private void onArmorstandUpdate(@NotNull class_1531 entity, boolean b) {
        if (!this.isEnabled()) {
            return;
        }
        if (this.currentTreeInfo == null) {
            return;
        }
        if (entity.method_23317() == this.currentTreeInfo.method_23317() && entity.method_23318() > this.currentTreeInfo.method_23318() && entity.method_23321() == this.currentTreeInfo.method_23321()) {
            this.currentInfo = entity.method_5477();
        }
    }

    private void reset() {
        this.currentInfo = null;
        this.currentTreeInfo = null;
    }

    private Optional<class_1531> findClosestTreeInfoInRange(@Nullable class_1297 entity) {
        if (TreeOverlayFeature.CLIENT.field_1687 == null || TreeOverlayFeature.CLIENT.field_1724 == null || entity == null) {
            return Optional.empty();
        }
        List armorStands = TreeOverlayFeature.CLIENT.field_1687.method_8390(class_1531.class, entity.method_5829().method_1014(10.0), class_1297::method_16914);
        class_1531 closestTreeInfoArmorStand = armorStands.stream().filter(as -> as.method_5477().getString().contains(CLIENT.method_1548().method_1676())).min(Comparator.comparingDouble(as -> as.method_5858(entity))).orElse(null);
        if (closestTreeInfoArmorStand == null) {
            return Optional.empty();
        }
        return Optional.of(closestTreeInfoArmorStand);
    }
}

