/*
 * Decompiled with CFR 0.152.
 */
package fr.siroz.cariboustonks.feature.item;

import fr.siroz.cariboustonks.CaribouStonks;
import fr.siroz.cariboustonks.config.ConfigManager;
import fr.siroz.cariboustonks.core.data.mod.ModDataSource;
import fr.siroz.cariboustonks.core.data.mod.SkyBlockEnchantment;
import fr.siroz.cariboustonks.core.skyblock.SkyBlockAPI;
import fr.siroz.cariboustonks.event.ItemRenderEvents;
import fr.siroz.cariboustonks.feature.Feature;
import fr.siroz.cariboustonks.util.ItemUtils;
import fr.siroz.cariboustonks.util.RomanNumeralUtils;
import fr.siroz.cariboustonks.util.render.animation.AnimationUtils;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.stream.Collectors;
import net.minecraft.class_124;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_5250;
import net.minecraft.class_7417;
import net.minecraft.class_9290;
import net.minecraft.class_9322;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ColoredEnchantmentFeature
extends Feature {
    private final ModDataSource modDataSource = CaribouStonks.core().getModDataSource();

    public ColoredEnchantmentFeature() {
        ItemRenderEvents.TOOLTIP_APPENDER.register(this::onTooltipLine);
    }

    @Override
    public boolean isEnabled() {
        return SkyBlockAPI.isOnSkyBlock() && (this.showGoodEnchants() || this.showMaxEnchants());
    }

    @Nullable
    private class_9290 onTooltipLine(class_1799 itemStack, class_9290 loreComponent) {
        if (itemStack == null || itemStack.method_7960()) {
            return null;
        }
        if (loreComponent == null || loreComponent.comp_2400().isEmpty()) {
            return null;
        }
        if (!this.isEnabled()) {
            return null;
        }
        if (!this.showMaxEnchants() && !this.showGoodEnchants()) {
            return null;
        }
        class_2487 enchantments = ItemUtils.getCustomData((class_9322)itemStack).method_68568("enchantments");
        if (enchantments.method_33133()) {
            return null;
        }
        Object2IntOpenHashMap maxEnchantmentColors = new Object2IntOpenHashMap();
        Object2IntOpenHashMap goodEnchantmentColors = new Object2IntOpenHashMap();
        for (String id : enchantments.method_10541()) {
            SkyBlockEnchantment enchantment = this.modDataSource.getSkyBlockEnchantment(id);
            int level = enchantments.method_68083(id, 0);
            if (enchantment == null || !enchantment.isGoodOrMaxLevel(level) || level <= 0) continue;
            String name = enchantment.name() + " " + RomanNumeralUtils.generate(level);
            if (enchantment.isMaxLevel(level)) {
                maxEnchantmentColors.put((Object)name, this.maxEnchantsColor().getRGB());
                continue;
            }
            if (!enchantment.isGoodLevel(level) || !this.showGoodEnchants()) continue;
            goodEnchantmentColors.put((Object)name, this.goodEnchantsColor().getRGB());
        }
        if (maxEnchantmentColors.isEmpty() && goodEnchantmentColors.isEmpty()) {
            return null;
        }
        boolean applied = false;
        List lines = loreComponent.comp_2400().stream().map(this::recursiveCopy).collect(Collectors.toList());
        for (class_2561 line : lines) {
            String enchant;
            if (this.showMaxEnchants() && !maxEnchantmentColors.isEmpty()) {
                if (maxEnchantmentColors.keySet().stream().anyMatch(line.getString()::contains)) {
                    if (this.maxEnchantsRainbow()) {
                        ListIterator<class_2561> iterator = line.method_10855().listIterator();
                        while (iterator.hasNext()) {
                            class_2561 currentText = (class_2561)iterator.next();
                            enchant = currentText.getString().trim();
                            if (!maxEnchantmentColors.containsKey((Object)enchant) || currentText.method_10866().method_10973().method_27716() != class_124.field_1078.method_532().intValue()) continue;
                            iterator.set(AnimationUtils.applyRainbow(enchant));
                            maxEnchantmentColors.removeInt((Object)enchant);
                            applied = true;
                        }
                    } else {
                        for (class_2561 currentText : line.method_10855()) {
                            enchant = currentText.getString().trim();
                            if (!maxEnchantmentColors.containsKey((Object)enchant) || currentText.method_10866().method_10973().method_27716() != class_124.field_1078.method_532().intValue()) continue;
                            ((class_5250)currentText).method_54663(maxEnchantmentColors.getInt((Object)enchant));
                            maxEnchantmentColors.removeInt((Object)enchant);
                            applied = true;
                        }
                    }
                }
            }
            if (!this.showGoodEnchants() || goodEnchantmentColors.isEmpty()) continue;
            if (!goodEnchantmentColors.keySet().stream().anyMatch(line.getString()::contains)) continue;
            for (class_2561 currentText : line.method_10855()) {
                enchant = currentText.getString().trim();
                if (!goodEnchantmentColors.containsKey((Object)enchant) || currentText.method_10866().method_10973().method_27716() != class_124.field_1078.method_532().intValue()) continue;
                ((class_5250)currentText).method_54663(goodEnchantmentColors.getInt((Object)enchant));
                goodEnchantmentColors.removeInt((Object)enchant);
                applied = true;
            }
        }
        if (applied) {
            return new class_9290(lines);
        }
        return null;
    }

    private boolean showMaxEnchants() {
        return ConfigManager.getConfig().uiAndVisuals.coloredEnchantment.showMaxEnchants;
    }

    private boolean showGoodEnchants() {
        return ConfigManager.getConfig().uiAndVisuals.coloredEnchantment.showGoodEnchants;
    }

    private Color maxEnchantsColor() {
        return ConfigManager.getConfig().uiAndVisuals.coloredEnchantment.maxEnchantsColor;
    }

    private boolean maxEnchantsRainbow() {
        return ConfigManager.getConfig().uiAndVisuals.coloredEnchantment.maxEnchantsRainbow;
    }

    private Color goodEnchantsColor() {
        return ConfigManager.getConfig().uiAndVisuals.coloredEnchantment.goodEnchantsColor;
    }

    @NotNull
    private class_5250 recursiveCopy(@NotNull class_2561 original) {
        class_5250 copy = class_5250.method_43477((class_7417)original.method_10851()).method_10862(original.method_10866());
        ((ArrayList)copy.method_10855()).ensureCapacity(original.method_10855().size());
        for (class_2561 sibling : original.method_10855()) {
            copy.method_10855().add(this.recursiveCopy(sibling));
        }
        return copy;
    }
}

