/*
 * Decompiled with CFR 0.152.
 */
package fr.siroz.cariboustonks.feature.misc;

import fr.siroz.cariboustonks.CaribouStonks;
import fr.siroz.cariboustonks.config.ConfigManager;
import fr.siroz.cariboustonks.config.configs.MiscConfig;
import fr.siroz.cariboustonks.core.skyblock.SkyBlockAPI;
import fr.siroz.cariboustonks.event.ChatEvents;
import fr.siroz.cariboustonks.feature.Feature;
import fr.siroz.cariboustonks.manager.network.NetworkManager;
import fr.siroz.cariboustonks.util.Client;
import fr.siroz.cariboustonks.util.StonksUtils;
import fr.siroz.cariboustonks.util.cooldown.Cooldown;
import fr.siroz.cariboustonks.util.position.Position;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import org.jetbrains.annotations.NotNull;

public class PartyCommandFeature
extends Feature {
    private static final class_310 CLIENT = class_310.method_1551();
    private static final Cooldown COOLDOWN = Cooldown.of(750L, TimeUnit.MILLISECONDS);

    public PartyCommandFeature() {
        ChatEvents.MESSAGE_RECEIVED.register(this::onChatMessage);
    }

    @Override
    public boolean isEnabled() {
        return SkyBlockAPI.isOnSkyBlock() && ConfigManager.getConfig().misc.partyCommands.enabled;
    }

    private void onChatMessage(@NotNull class_2561 text) {
        if (!this.isEnabled()) {
            return;
        }
        String input = StonksUtils.stripColor(text.getString());
        if (!input.startsWith("Party >")) {
            return;
        }
        if (PartyCommandFeature.CLIENT.field_1724 == null || PartyCommandFeature.CLIENT.field_1687 == null) {
            return;
        }
        if (!COOLDOWN.test()) {
            return;
        }
        for (PartyCommand command : PartyCommand.values()) {
            Matcher matcher;
            if (!command.getConfig().test(ConfigManager.getConfig().misc.partyCommands) || !(matcher = command.getPattern().matcher(input)).find()) continue;
            try {
                command.getAction().accept(matcher);
            }
            catch (Exception ex) {
                CaribouStonks.LOGGER.error("[PartyCommandFeature] Unable to handle {}", (Object)command.name(), (Object)ex);
            }
        }
    }

    private static enum PartyCommand {
        COORDS(Pattern.compile("Party > (\\[.+])? ?(.+) ?[\u127e\u2692]?: !coords"), cmd -> cmd.coords, matcher -> {
            Position position = Position.of(Client.getCurrentPosition());
            Client.sendChatMessage("/pc " + position.asChatCoordinates(), true);
        }),
        WARP(Pattern.compile("Party > (\\[.+])? ?(.+) ?[\u127e\u2692]?: !warp"), cmd -> cmd.warp, matcher -> Client.sendChatMessage("/p warp")),
        DICE(Pattern.compile("Party > (\\[.+])? ?(.+) ?[\u127e\u2692]?: !dice"), cmd -> cmd.diceGame, matcher -> {
            int roll = (int)(1.0 + Math.floor(Math.random() * 6.0));
            String extra = roll == 1 ? " Sheeh!" : (roll == 6 ? " Waw!" : "");
            String message = matcher.group(2) + " rolled a " + roll + "." + extra;
            Client.sendChatMessage("/pc " + message);
        }),
        CF(Pattern.compile("Party > (\\[.+])? ?(.+) ?[\u127e\u2692]?: !cf"), cmd -> cmd.coinFlip, matcher -> {
            if (new Random().nextBoolean()) {
                Client.sendChatMessage("/pc HEADS!");
            } else {
                Client.sendChatMessage("/pc TAILS!");
            }
        }),
        TPS(Pattern.compile("Party > (\\[.+])? ?(.+) ?[\u127e\u2692]?: !tps"), cmd -> cmd.tps, matcher -> {
            float tps = CaribouStonks.managers().getManager(NetworkManager.class).getTickRate();
            String message = String.format("TPS: %.1f", Float.valueOf(tps));
            Client.sendChatMessage("/pc " + message);
        });

        private final Pattern pattern;
        private final Predicate<MiscConfig.PartyCommands> config;
        private final Consumer<Matcher> action;

        private PartyCommand(Pattern pattern, Predicate<MiscConfig.PartyCommands> config, Consumer<Matcher> action) {
            this.pattern = pattern;
            this.config = config;
            this.action = action;
        }

        public Pattern getPattern() {
            return this.pattern;
        }

        public Predicate<MiscConfig.PartyCommands> getConfig() {
            return this.config;
        }

        public Consumer<Matcher> getAction() {
            return this.action;
        }
    }
}

